/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import javax.management.ObjectName;
import org.jboss.deployers.plugins.classloading.ClassLoading;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.classloading.ClassLoaderMetaData;
import org.jboss.deployers.structure.spi.classloading.ExportAll;
import org.jboss.deployers.structure.spi.classloading.Version;
import org.jboss.mx.loading.LoaderRepositoryFactory;

public class HackClassloaderMetaDataDeployer
extends AbstractRealDeployer {
    private ClassLoading classLoading;

    public ClassLoading getClassLoading() {
        return this.classLoading;
    }

    public void setClassLoading(ClassLoading classLoading) {
        this.classLoading = classLoading;
    }

    public HackClassloaderMetaDataDeployer() {
        this.setStage(DeploymentStages.DESCRIBE);
    }

    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig = unit.getAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class);
        if (loaderConfig != null) {
            String domain;
            this.log.debug("Using loader repository config: " + loaderConfig.repositoryName);
            ObjectName name = loaderConfig.repositoryName;
            if (name != null && (domain = name.getCanonicalName().trim()).length() != 0) {
                ClassLoaderMetaData metaData = new ClassLoaderMetaData();
                metaData.setName(unit.getName());
                metaData.setDomain(domain);
                metaData.setExportAll(ExportAll.NON_EMPTY);
                metaData.setImportAll(true);
                metaData.setVersion(Version.DEFAULT_VERSION);
                Properties props = new Properties();
                String config = loaderConfig.repositoryConfig;
                try {
                    if (config != null) {
                        ByteArrayInputStream bais = new ByteArrayInputStream(config.getBytes());
                        props.load(bais);
                    }
                }
                catch (Exception e) {
                    throw DeploymentException.rethrowAsDeploymentException("Error parsing repository config " + config, e);
                }
                String java2ParentDelegation = props.getProperty("java2ParentDelegation");
                if (java2ParentDelegation == null) {
                    java2ParentDelegation = props.getProperty("java2ParentDelegaton", "false");
                }
                boolean useParentFirst = Boolean.valueOf(java2ParentDelegation);
                metaData.setJ2seClassLoadingCompliance(useParentFirst);
                unit.addAttachment(ClassLoaderMetaData.class, metaData);
            }
        }
        this.classLoading.addDeploymentUnit(unit);
    }

    public void internalUndeploy(DeploymentUnit unit) {
        this.classLoading.removeDeploymentUnit(unit);
    }
}

