/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;
import org.jboss.security.mapping.providers.MappingProviderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsRoleMappingProvider
implements MappingProvider<Group> {
    private static final Logger log = Logger.getLogger(OptionsRoleMappingProvider.class);
    private static final String REPLACE_ROLES_STRING = "replaceRoles";
    private static final String ROLES_MAP = "rolesMap";
    private MappingResult<Group> result;
    private Map options = null;
    private Properties roleMapProperties = null;
    private boolean REPLACE_ROLES = false;

    @Override
    public void init(Map opt) {
        this.options = opt;
        if (this.options != null) {
            if (this.options.containsKey(REPLACE_ROLES_STRING)) {
                this.REPLACE_ROLES = "true".equalsIgnoreCase((String)this.options.get(REPLACE_ROLES_STRING));
            }
            if (this.options.containsKey(ROLES_MAP)) {
                this.roleMapProperties = (Properties)this.options.get(ROLES_MAP);
            }
        }
    }

    @Override
    public void setMappingResult(MappingResult res) {
        this.result = res;
    }

    @Override
    public void performMapping(Map contextMap, Group mappedObject) {
        ArrayList<Principal> removeMembers = new ArrayList<Principal>();
        ArrayList<Principal> addMembers = new ArrayList<Principal>();
        Enumeration enumer = mappedObject.members();
        while (enumer.hasMoreElements()) {
            Principal p = (Principal)enumer.nextElement();
            String name = p.getName();
            String commaSeparatedRoles = this.roleMapProperties.getProperty(name);
            if (commaSeparatedRoles == null) continue;
            String[] tokens = MappingProviderUtil.getRolesFromCommaSeparatedString(commaSeparatedRoles);
            int len = tokens != null ? tokens.length : 0;
            for (int i = 0; i < len; ++i) {
                if (this.REPLACE_ROLES) {
                    removeMembers.add(p);
                }
                addMembers.add(MappingProviderUtil.instantiatePrincipal(p.getClass(), tokens[i]));
            }
        }
        for (Principal p : removeMembers) {
            mappedObject.removeMember(p);
        }
        for (Principal p : addMembers) {
            mappedObject.addMember(p);
        }
        this.result.setMappedObject(mappedObject);
    }
}

