/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.SystemAuthenticatorMBean;
import org.jboss.system.ServiceMBeanSupport;

public class SystemAuthenticator
extends ServiceMBeanSupport
implements SystemAuthenticatorMBean {
    private Subject systemSubject;
    private String securityDomain;
    private CallbackHandler callbackHandler;

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String name) {
        this.securityDomain = name;
    }

    public Class getCallbackHandler() {
        Class<?> clazz = null;
        if (this.callbackHandler != null) {
            clazz = this.callbackHandler.getClass();
        }
        return clazz;
    }

    public void setCallbackHandler(Class callbackHandlerClass) throws InstantiationException, IllegalAccessException {
        this.callbackHandler = (CallbackHandler)callbackHandlerClass.newInstance();
    }

    protected void startService() throws Exception {
        try {
            LoginContext lc = new LoginContext(this.securityDomain, this.callbackHandler);
            lc.login();
            this.systemSubject = lc.getSubject();
        }
        catch (Throwable t) {
            this.log.fatal("SystemAuthenticator failed, server will shutdown NOW!", t);
            LoginException le = new LoginException("SystemAuthenticator failed, msg=" + t.getMessage());
            Thread shutdownThread = new Thread("SystemAuthenticatorExitThread"){

                public void run() {
                    System.exit(1);
                }
            };
            shutdownThread.start();
        }
    }

    protected void stopService() throws Exception {
        if (this.systemSubject != null) {
            LoginContext lc = new LoginContext(this.securityDomain, this.systemSubject, this.callbackHandler);
            lc.logout();
        }
    }
}

