/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.remote;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.jboss.resource.adapter.jdbc.JBossWrapper;

public class SerializableResultSetMetaData
extends JBossWrapper
implements ResultSetMetaData,
Serializable {
    static final long serialVersionUID = -6663485432752348789L;
    private ColumnData[] columnData;

    SerializableResultSetMetaData(ResultSetMetaData metaData) throws SQLException {
        int count = metaData.getColumnCount();
        this.columnData = new ColumnData[count + 1];
        for (int c = 1; c <= count; ++c) {
            ColumnData data;
            this.columnData[c] = data = new ColumnData();
            data.label = metaData.getColumnLabel(c);
            data.name = metaData.getColumnName(c);
            data.type = metaData.getColumnType(c);
        }
    }

    public int getColumnCount() throws SQLException {
        return this.columnData.length - 1;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    public int isNullable(int column) throws SQLException {
        return 0;
    }

    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return 0;
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.columnData[column].label;
    }

    public String getColumnName(int column) throws SQLException {
        return this.columnData[column].name;
    }

    public String getSchemaName(int column) throws SQLException {
        return null;
    }

    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    public int getScale(int column) throws SQLException {
        return 0;
    }

    public String getTableName(int column) throws SQLException {
        return "";
    }

    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        return this.columnData[column].type;
    }

    public String getColumnTypeName(int column) throws SQLException {
        return this.columnData[column].typeName;
    }

    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        return this.columnData[column].className;
    }

    private static class ColumnData
    implements Serializable {
        static final long serialVersionUID = 5060626133767712300L;
        String className;
        String label;
        String name;
        int type;
        String typeName;

        private ColumnData() {
        }
    }
}

