/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.Enumeration;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoadingTaskDCL;
import org.jboss.mx.loading.LegacyDomainClassLoader;
import org.jboss.mx.loading.LoadMgrDCL;
import org.jboss.mx.loading.LoaderRepositoryDomain;
import org.jboss.mx.loading.UnifiedClassLoaderMBean;
import org.jboss.mx.loading.UnifiedLoaderRepositoryDCL;

public class DomainClassLoaderUCLImpl
extends LegacyDomainClassLoader
implements UnifiedClassLoaderMBean {
    private static final Logger log = Logger.getLogger(DomainClassLoaderUCLImpl.class);

    public DomainClassLoaderUCLImpl(URL[] cp, LoaderRepositoryDomain repository) {
        super(cp, null);
        repository.addClassLoader(this);
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        String name = "jmx.loading:UCL=" + Integer.toHexString(super.hashCode());
        return new ObjectName(name);
    }

    public String[] getPackageNames() {
        UnifiedLoaderRepositoryDCL ulr = (UnifiedLoaderRepositoryDCL)this.domain;
        return ulr.getPackageNames(this);
    }

    public void unregister() {
        super.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Class loadClassImpl(String name, boolean resolve, int stopAt) throws ClassNotFoundException {
        ClassLoadingTaskDCL task;
        block21: {
            ++this.loadClassDepth;
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace("loadClassImpl, name=" + name + ", resolve=" + resolve);
            }
            if (this.domain == null) {
                try {
                    return super.loadClass(name, resolve);
                }
                catch (ClassNotFoundException ignored) {
                    String msg = "Invalid use of destroyed classloader, UCL destroyed at:";
                    throw new ClassNotFoundException(msg, this.unregisterTrace);
                }
            }
            boolean acquired = this.attempt(1L);
            while (!acquired) {
                try {
                    if (trace) {
                        log.trace("Waiting for loadClass lock");
                    }
                    this.wait();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                acquired = this.attempt(1L);
            }
            task = null;
            try {
                UnifiedLoaderRepositoryDCL repository;
                Thread t = Thread.currentThread();
                if (this.loadLock.holds() == 1L) {
                    LoadMgrDCL.registerLoaderThread(this, t);
                }
                if (LoadMgrDCL.beginLoadTask(task = new ClassLoadingTaskDCL(name, this, t, stopAt), repository = (UnifiedLoaderRepositoryDCL)this.domain)) break block21;
                while (task.threadTaskCount != 0) {
                    try {
                        LoadMgrDCL.nextTask(t, task, repository);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.loadLock.holds() == 1L) {
                    LoadMgrDCL.endLoadTask(task);
                }
                this.release();
                this.notifyAll();
                --this.loadClassDepth;
                throw throwable;
            }
        }
        if (this.loadLock.holds() == 1L) {
            LoadMgrDCL.endLoadTask(task);
        }
        this.release();
        this.notifyAll();
        --this.loadClassDepth;
        if (task.loadedClass != null) {
            return task.loadedClass;
        }
        if (task.loadException instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)task.loadException;
        }
        if (task.loadException instanceof NoClassDefFoundError) {
            throw (NoClassDefFoundError)task.loadException;
        }
        if (task.loadException == null) {
            throw new IllegalStateException("ClassLoadingTask.loadedTask is null, name: " + name);
        }
        if (log.isTraceEnabled()) {
            log.trace("Unexpected error during load of:" + name, task.loadException);
        }
        String msg = "Unexpected error during load of: " + name + ", msg=" + task.loadException.getMessage();
        ClassNotFoundException cnfe = new ClassNotFoundException(msg, task.loadException);
        throw cnfe;
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        CodeSource permCS = cs;
        Policy policy = Policy.getPolicy();
        PermissionCollection perms = super.getPermissions(permCS);
        PermissionCollection perms2 = super.getPermissions(cs);
        PermissionCollection perms3 = policy.getPermissions(permCS);
        Enumeration<Permission> iter = perms2.elements();
        while (iter.hasMoreElements()) {
            perms.add(iter.nextElement());
        }
        iter = perms3.elements();
        while (iter.hasMoreElements()) {
            perms.add(iter.nextElement());
        }
        if (log.isTraceEnabled()) {
            log.trace("getPermissions, cp: " + this.getURLs() + " -> " + perms);
        }
        return perms;
    }
}

