/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Streamable;

public class Version
implements Streamable,
Serializable {
    private static final long serialVersionUID = 3605477218138273630L;
    private static final Logger log = Logger.getLogger(Version.class);
    private String jmsVersion = "UNKNOWN";
    private int jmsMajorVersion = 0;
    private int jmsMinorVersion = 0;
    private String jmsProviderName = "UNKNOWN";
    private String providerVersion = "UNKNOWN";
    private int providerMajorVersion = 0;
    private int providerMinorVersion = 0;
    private byte providerIncrementingVersion;
    private static Version singleton;

    private Version(String versionFile) {
        this.load(versionFile);
    }

    public Version() {
    }

    public static synchronized Version instance() {
        if (singleton == null) {
            singleton = new Version("VERSION");
        }
        return singleton;
    }

    public String getJMSVersion() {
        return this.jmsVersion;
    }

    public int getJMSMajorVersion() {
        return this.jmsMajorVersion;
    }

    public int getJMSMinorVersion() {
        return this.jmsMinorVersion;
    }

    public String getJMSProviderName() {
        return this.jmsProviderName;
    }

    public String getProviderVersion() {
        return this.providerVersion;
    }

    public int getProviderMajorVersion() {
        return this.providerMajorVersion;
    }

    public int getProviderMinorVersion() {
        return this.providerMinorVersion;
    }

    public byte getProviderIncrementingVersion() {
        return this.providerIncrementingVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String versionFile) {
        InputStream is = null;
        try {
            Properties versionInfo = new Properties();
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(versionFile);
            versionInfo.load(is);
            String s = versionInfo.getProperty("jboss.messaging.jmsVersion");
            if (s != null) {
                this.jmsVersion = s;
            }
            if ((s = versionInfo.getProperty("jboss.messaging.jmsMajorVersion")) != null) {
                try {
                    this.jmsMajorVersion = Integer.parseInt(s);
                }
                catch (Exception e) {
                    log.debug("failed to parse jmsMajorVersion: " + s);
                }
            }
            if ((s = versionInfo.getProperty("jboss.messaging.jmsMinorVersion")) != null) {
                try {
                    this.jmsMinorVersion = Integer.parseInt(s);
                }
                catch (Exception e) {
                    log.debug("failed to parse jmsMinorVersion: " + s);
                }
            }
            if ((s = versionInfo.getProperty("jboss.messaging.jmsProviderName")) != null) {
                this.jmsProviderName = s;
            }
            if ((s = versionInfo.getProperty("jboss.messaging.providerVersion")) != null) {
                this.providerVersion = s;
            }
            if ((s = versionInfo.getProperty("jboss.messaging.providerMajorVersion")) != null) {
                try {
                    this.providerMajorVersion = Integer.parseInt(s);
                }
                catch (Exception e) {
                    log.debug("failed to parse providerMajorVersion: " + s);
                }
            }
            if ((s = versionInfo.getProperty("jboss.messaging.providerMinorVersion")) != null) {
                try {
                    this.providerMinorVersion = Integer.parseInt(s);
                }
                catch (Exception e) {
                    log.debug("failed to parse providerMinorVersion: " + s);
                }
            }
            if ((s = versionInfo.getProperty("jboss.messaging.providerIncrementingVersion")) != null) {
                try {
                    this.providerIncrementingVersion = Byte.parseByte(s);
                }
                catch (Exception e) {
                    log.debug("failed to parse providerIncrementingVersion: " + s);
                }
            }
        }
        catch (Exception e) {
            log.warn("Unable to read version info: " + e.getMessage());
            log.debug("Unable to read version info", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    log.debug("failed to close the version info stream", e);
                }
            }
        }
    }

    public void read(DataInputStream in) throws Exception {
        this.jmsVersion = in.readUTF();
        this.jmsMajorVersion = in.readInt();
        this.jmsMinorVersion = in.readInt();
        this.jmsProviderName = in.readUTF();
        this.providerVersion = in.readUTF();
        this.providerMajorVersion = in.readInt();
        this.providerMinorVersion = in.readInt();
        this.providerIncrementingVersion = in.readByte();
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeUTF(this.jmsVersion);
        out.writeInt(this.jmsMajorVersion);
        out.writeInt(this.jmsMinorVersion);
        out.writeUTF(this.jmsProviderName);
        out.writeUTF(this.providerVersion);
        out.writeInt(this.providerMajorVersion);
        out.writeInt(this.providerMinorVersion);
        out.writeByte(this.providerIncrementingVersion);
    }
}

