/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.clusterconnection;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.TimedCallable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.jboss.jms.client.JBossConnection;
import org.jboss.jms.client.JBossConnectionFactory;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Binding;
import org.jboss.messaging.core.contract.ClusterNotification;
import org.jboss.messaging.core.contract.ClusterNotificationListener;
import org.jboss.messaging.core.contract.PostOffice;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.core.contract.Replicator;
import org.jboss.messaging.core.impl.clusterconnection.MessageSucker;

public class ClusterConnectionManager
implements ClusterNotificationListener {
    private static final Logger log = Logger.getLogger(ClusterConnectionManager.class);
    private static final long CLOSE_TIMEOUT = 2000L;
    private boolean trace = log.isTraceEnabled();
    private Map connections = new HashMap();
    private boolean xa;
    private boolean started;
    private int nodeID;
    private String connectionFactoryUniqueName;
    private Replicator replicator;
    private PostOffice postOffice;
    private boolean preserveOrdering;
    private String suckerUser;
    private String suckerPassword;

    public ClusterConnectionManager(boolean xa, int nodeID, String connectionFactoryUniqueName, boolean preserveOrdering, String suckerUser, String suckerPassword) {
        this.xa = xa;
        this.nodeID = nodeID;
        this.connectionFactoryUniqueName = connectionFactoryUniqueName;
        this.preserveOrdering = preserveOrdering;
        this.suckerUser = suckerUser;
        this.suckerPassword = suckerPassword;
        if (this.trace) {
            log.trace("Created " + this);
        }
    }

    public void injectReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    public void injectPostOffice(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        if (this.trace) {
            log.trace(this + " started");
        }
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        for (ConnectionInfo info : this.connections.values()) {
            info.close();
        }
        this.connections.clear();
        this.started = false;
        if (this.trace) {
            log.trace(this + " stopped");
        }
    }

    public Map getAllConnections() {
        return this.connections;
    }

    public void resetAllSuckers() {
        for (ConnectionInfo conn : this.connections.values()) {
            conn.resetAllSuckers();
        }
    }

    public void setIsXA(boolean xa) throws Exception {
        boolean needToClose;
        boolean bl = needToClose = this.xa != xa;
        if (needToClose) {
            this.closeAllSuckers();
        }
        this.xa = xa;
        if (needToClose) {
            this.createAllSuckers();
        }
    }

    public void closeAllSuckers() {
        for (ConnectionInfo conn : this.connections.values()) {
            conn.closeAllSuckers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notify(ClusterNotification notification) {
        block31: {
            if (this.replicator == null) {
                return;
            }
            if (this.trace) {
                log.trace(this + " notification received " + notification);
            }
            try {
                if (notification.type == 6 && notification.data instanceof String) {
                    String uniqueName;
                    String key = (String)notification.data;
                    if (!key.startsWith("CF_") || !(uniqueName = key.substring("CF_".length())).equals(this.connectionFactoryUniqueName)) break block31;
                    log.trace(this + " deployment of ClusterConnectionFactory");
                    ClusterConnectionManager clusterConnectionManager = this;
                    synchronized (clusterConnectionManager) {
                        this.ensureAllConnectionsCreated();
                        this.createAllSuckers();
                        break block31;
                    }
                }
                if (notification.type == 7 && notification.data instanceof String) {
                    String uniqueName;
                    String key = (String)notification.data;
                    if (key.startsWith("CF_") && (uniqueName = key.substring("CF_".length())).equals(this.connectionFactoryUniqueName)) {
                        Map updatedReplicantMap = this.replicator.get((Serializable)((Object)key));
                        ArrayList<Integer> toRemove = new ArrayList<Integer>();
                        for (Map.Entry entry : this.connections.entrySet()) {
                            Integer nid = (Integer)entry.getKey();
                            if (updatedReplicantMap.get(nid) != null) continue;
                            toRemove.add(nid);
                        }
                        for (Integer nid : toRemove) {
                            ConnectionInfo info = (ConnectionInfo)this.connections.remove(nid);
                            info.close();
                        }
                    }
                } else if (notification.type == 0) {
                    String queueName = (String)notification.data;
                    if (this.trace) {
                        log.trace(this + " bind of queue " + queueName);
                    }
                    if (notification.nodeID == this.nodeID) {
                        if (this.trace) {
                            log.trace(this + " Local bind");
                        }
                        this.ensureAllConnectionsCreated();
                        Collection bindings = this.postOffice.getAllBindingsForQueueName(queueName);
                        Iterator iter = bindings.iterator();
                        if (this.trace) {
                            log.trace(this + " Looking for remote bindings");
                        }
                        while (iter.hasNext()) {
                            Binding binding = (Binding)iter.next();
                            if (this.trace) {
                                log.trace(this + " Remote binding is " + binding);
                            }
                            if (binding.queue.getNodeID() == this.nodeID) continue;
                            if (this.trace) {
                                log.trace(this + " Creating sucker");
                            }
                            this.createSucker(queueName, binding.queue.getNodeID());
                        }
                    } else {
                        if (this.trace) {
                            log.trace(this + " Remote bind");
                        }
                        this.ensureAllConnectionsCreated();
                        Binding localBinding = this.postOffice.getBindingForQueueName(queueName);
                        if (localBinding == null) {
                            if (this.trace) {
                                log.trace(this + " There's no local binding");
                            }
                        } else {
                            if (this.trace) {
                                log.trace(this + " Creating sucker");
                            }
                            this.createSucker(queueName, notification.nodeID);
                        }
                    }
                } else if (notification.type == 1) {
                    String queueName = (String)notification.data;
                    if (notification.nodeID == this.nodeID) {
                        this.removeAllSuckers(queueName);
                    } else {
                        this.removeSucker(queueName, notification.nodeID);
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to process notification", e);
            }
        }
    }

    public String toString() {
        return "ClusterConnectionManager:" + System.identityHashCode(this) + " xa: " + this.xa + " nodeID: " + this.nodeID + " connectionFactoryName: " + this.connectionFactoryUniqueName;
    }

    private void ensureAllConnectionsCreated() throws Exception {
        Map updatedReplicantMap = this.replicator.get((Serializable)((Object)("CF_" + this.connectionFactoryUniqueName)));
        for (Map.Entry entry : updatedReplicantMap.entrySet()) {
            Integer nid = (Integer)entry.getKey();
            ClientConnectionFactoryDelegate delegate = (ClientConnectionFactoryDelegate)entry.getValue();
            if (this.connections.get(nid) != null) continue;
            try {
                ConnectionInfo info = new ConnectionInfo(new JBossConnectionFactory(delegate), this.suckerUser, this.suckerPassword);
                log.trace(this + " created connection info " + info);
                this.connections.put(nid, info);
                info.start();
            }
            catch (Exception e) {
                log.error("Failed to start connection info ", e);
            }
        }
    }

    private void createSucker(String queueName, int nodeID) throws Exception {
        log.debug("createSucker " + queueName + " nodeID=" + nodeID);
        ConnectionInfo info = (ConnectionInfo)this.connections.get(new Integer(nodeID));
        if (info == null) {
            if (this.trace) {
                log.trace("Cluster pull connection factory has not yet been deployed on node " + nodeID);
            }
            return;
        }
        ConnectionInfo localInfo = (ConnectionInfo)this.connections.get(new Integer(this.nodeID));
        if (localInfo == null) {
            if (this.trace) {
                log.trace("Cluster pull connection factory has not yet been deployed on local node");
            }
            return;
        }
        if (!info.hasSucker(queueName)) {
            if (this.trace) {
                log.trace("Creating Sucker for queue " + queueName + " node " + nodeID);
            }
            Binding binding = this.postOffice.getBindingForQueueName(queueName);
            Queue localQueue = binding.queue;
            if (localQueue.isClustered()) {
                MessageSucker sucker = new MessageSucker(localQueue, info.connection, localInfo.connection, this.xa, this.preserveOrdering);
                info.addSucker(sucker);
                sucker.start();
                if (this.trace) {
                    log.trace("Started it");
                }
            }
        } else if (this.trace) {
            log.trace("Sucker for queue " + queueName + " node " + nodeID + " already exists, not creating it");
        }
    }

    private void removeSucker(String queueName, int nodeID) {
        log.debug("removeSucker " + queueName + " nodeID=" + nodeID);
        ConnectionInfo info = (ConnectionInfo)this.connections.get(new Integer(nodeID));
        if (info == null) {
            return;
        }
        MessageSucker sucker = info.removeSucker(queueName);
        if (sucker != null) {
            sucker.stop();
        }
    }

    private void removeAllSuckers(String queueName) {
        log.debug("removeAllSuckers " + queueName);
        for (ConnectionInfo info : this.connections.values()) {
            MessageSucker sucker = info.removeSucker(queueName);
            if (sucker == null) continue;
            sucker.stop();
        }
    }

    private void createAllSuckers() throws Exception {
        Collection allBindings = this.postOffice.getAllBindings();
        Iterator<Object> iter = allBindings.iterator();
        HashMap<String, ArrayList<Queue>> nameMap = new HashMap<String, ArrayList<Queue>>();
        while (iter.hasNext()) {
            Binding binding = (Binding)iter.next();
            if (!binding.queue.isClustered()) continue;
            ArrayList<Queue> queues = (ArrayList<Queue>)nameMap.get(binding.queue.getName());
            if (queues == null) {
                queues = new ArrayList<Queue>();
                nameMap.put(binding.queue.getName(), queues);
            }
            queues.add(binding.queue);
        }
        for (Map.Entry entry : nameMap.entrySet()) {
            String queueName = (String)entry.getKey();
            List queues = (List)entry.getValue();
            Iterator iter2 = queues.iterator();
            Queue localQueue = null;
            while (iter2.hasNext()) {
                Queue queue = (Queue)iter2.next();
                if (queue.getNodeID() != this.nodeID) continue;
                localQueue = queue;
                break;
            }
            if (localQueue == null) continue;
            for (Queue queue : queues) {
                if (queue.getNodeID() == this.nodeID || !queue.isClustered()) continue;
                this.createSucker(queueName, queue.getNodeID());
            }
        }
    }

    class ConnectionInfo {
        private JBossConnectionFactory connectionFactory;
        private JBossConnection connection;
        private Map suckers;
        private boolean started;
        private String suckerUser;
        private String suckerPassword;

        ConnectionInfo(JBossConnectionFactory connectionFactory, String suckerUser, String suckerPassword) throws Exception {
            this.connectionFactory = connectionFactory;
            this.suckers = new HashMap();
            this.suckerUser = suckerUser;
            this.suckerPassword = suckerPassword;
        }

        synchronized void start() throws Exception {
            if (this.started) {
                return;
            }
            if (this.connection == null) {
                this.connection = (JBossConnection)this.connectionFactory.createConnection(this.suckerUser, this.suckerPassword);
            }
            this.connection.start();
            this.started = true;
        }

        synchronized void stop() throws Exception {
            if (!this.started) {
                return;
            }
            this.connection.stop();
            this.started = false;
        }

        synchronized void resetAllSuckers() {
            for (MessageSucker sucker : this.suckers.values()) {
                sucker.setConsuming(false);
            }
        }

        synchronized void closeAllSuckers() {
            for (MessageSucker sucker : this.suckers.values()) {
                sucker.stop();
            }
            this.suckers.clear();
        }

        synchronized void close() {
            this.closeAllSuckers();
            Callable callable = new Callable(){

                public Object call() {
                    try {
                        ConnectionInfo.this.connection.close();
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                    return null;
                }
            };
            TimedCallable timedCallable = new TimedCallable(callable, 2000L);
            try {
                timedCallable.call();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection = null;
            this.started = false;
        }

        synchronized boolean hasSucker(String queueName) {
            return this.suckers.containsKey(queueName);
        }

        synchronized void addSucker(MessageSucker sucker) {
            if (this.suckers.containsKey(sucker.getQueueName())) {
                throw new IllegalStateException("Already has sucker for queue " + sucker.getQueueName());
            }
            this.suckers.put(sucker.getQueueName(), sucker);
        }

        synchronized MessageSucker removeSucker(String queueName) {
            MessageSucker sucker = (MessageSucker)this.suckers.remove(queueName);
            return sucker;
        }
    }
}

