/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedDeploymentImpl
implements ManagedDeployment,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String simpleName;
    private Set<String> types;
    private ManagedDeployment.DeploymentPhase phase;
    private ManagedDeployment parent;
    private Map<String, ManagedObject> unitMOs;
    private Map<String, ManagedProperty> properties;
    private Map<String, ManagedComponent> components = new HashMap<String, ManagedComponent>();
    private List<ManagedDeployment> children = new ArrayList<ManagedDeployment>();

    public ManagedDeploymentImpl(String name, String simpleName, ManagedDeployment.DeploymentPhase phase, ManagedDeployment parent, Map<String, ManagedObject> unitMOs) {
        this.name = name;
        this.simpleName = simpleName;
        this.phase = phase;
        this.parent = parent;
        this.unitMOs = unitMOs;
        this.properties = new HashMap<String, ManagedProperty>();
        for (ManagedObject mo : unitMOs.values()) {
            this.properties.putAll(mo.getProperties());
        }
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public boolean addType(String type) {
        return this.types.add(type);
    }

    @Override
    public Set<String> getTypes() {
        return this.types;
    }

    @Override
    public void setTypes(Set<String> types) {
        this.types = types;
    }

    @Override
    public ManagedDeployment.DeploymentPhase getDeploymentPhase() {
        return this.phase;
    }

    @Override
    public ManagedDeployment getParent() {
        return this.parent;
    }

    @Override
    public Set<String> getComponentTemplateNames() {
        return null;
    }

    @Override
    public void addComponent(String name, ManagedComponent comp) {
        this.components.put(name, comp);
    }

    @Override
    public ManagedComponent getComponent(String name) {
        return this.components.get(name);
    }

    @Override
    public Map<String, ManagedComponent> getComponents() {
        return this.components;
    }

    @Override
    public boolean removeComponent(String name) {
        ManagedComponent mc = this.components.remove(name);
        return mc != null;
    }

    @Override
    public Set<String> getDeploymentTemplateNames() {
        return null;
    }

    @Override
    public List<ManagedDeployment> getChildren() {
        return this.children;
    }

    @Override
    public ManagedDeployment addModule(String deplymentBaseName, DeploymentTemplateInfo info) {
        return null;
    }

    @Override
    public Map<String, ManagedProperty> getProperties() {
        return this.properties;
    }

    @Override
    public ManagedProperty getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public Set<String> getManagedObjectNames() {
        return this.unitMOs.keySet();
    }

    @Override
    public Map<String, ManagedObject> getManagedObjects() {
        return this.unitMOs;
    }

    @Override
    public ManagedObject getManagedObject(String name) {
        return this.unitMOs.get(name);
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(super.toString());
        tmp.append('{');
        tmp.append("name=");
        tmp.append(this.getName());
        tmp.append(", types=");
        tmp.append(this.types);
        tmp.append(", phase=");
        tmp.append((Object)this.phase);
        tmp.append(", parent=");
        if (this.parent != null) {
            tmp.append("ManagedDeployment@");
            tmp.append(System.identityHashCode(this.parent));
        } else {
            tmp.append("null");
        }
        tmp.append(", components=");
        tmp.append(this.components);
        tmp.append(", children=");
        tmp.append(this.children);
        tmp.append('}');
        return tmp.toString();
    }
}

