/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.destination;

import java.util.Collection;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import org.jboss.jms.server.JMSCondition;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.destination.DestinationMBean;
import org.jboss.jms.server.destination.ManagedDestination;
import org.jboss.jms.server.destination.ManagedQueue;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.messaging.core.contract.MessagingComponent;
import org.jboss.messaging.core.contract.PostOffice;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.util.ExceptionUtil;
import org.jboss.messaging.util.JMXAccessor;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Element;

public abstract class DestinationServiceSupport
extends ServiceMBeanSupport
implements DestinationMBean {
    private ObjectName serverPeerObjectName;
    private ObjectName dlqObjectName;
    private ObjectName expiryQueueObjectName;
    protected boolean started = false;
    protected ManagedDestination destination;
    protected ServerPeer serverPeer;
    protected int nodeId;
    private boolean createdProgrammatically;

    public DestinationServiceSupport(boolean createdProgrammatically) {
        this.createdProgrammatically = createdProgrammatically;
    }

    public DestinationServiceSupport() {
    }

    public MessagingComponent getInstance() {
        return this.destination;
    }

    public synchronized void startService() throws Exception {
        super.startService();
        try {
            this.serverPeer = (ServerPeer)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.serverPeerObjectName, "Instance");
            this.destination.setServerPeer(this.serverPeer);
            this.nodeId = this.serverPeer.getServerPeerID();
            String name = null;
            if (this.serviceName != null) {
                name = this.serviceName.getKeyProperty("name");
            }
            if (name == null || name.length() == 0) {
                throw new IllegalStateException("The " + (this.isQueue() ? "queue" : "topic") + " " + "name was not properly set in the service's" + "ObjectName");
            }
            this.destination.setName(name);
            this.setMaxSizeForQueues();
            if (this.destination.getSecurityConfig() != null) {
                this.serverPeer.getSecurityManager().setSecurityConfig(this.isQueue(), this.destination.getName(), this.destination.getSecurityConfig());
            }
        }
        catch (Throwable t) {
            ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    public synchronized void stopService() throws Exception {
        super.stopService();
    }

    public String getName() {
        return this.destination.getName();
    }

    public String getJNDIName() {
        return this.destination.getJndiName();
    }

    public void setJNDIName(String jndiName) throws Exception {
        try {
            if (this.started) {
                this.log.warn("Cannot change the value of the JNDI name after initialization!");
                return;
            }
            this.destination.setJndiName(jndiName);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " setJNDIName");
        }
    }

    public void setServerPeer(ObjectName on) {
        if (this.started) {
            this.log.warn("Cannot change the value of associated server's ObjectName after initialization!");
            return;
        }
        this.serverPeerObjectName = on;
    }

    public ObjectName getServerPeer() {
        return this.serverPeerObjectName;
    }

    public void setDLQ(ObjectName on) throws Exception {
        this.dlqObjectName = on;
        ManagedQueue dest = null;
        try {
            try {
                dest = (ManagedQueue)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.dlqObjectName, "Instance");
            }
            catch (InstanceNotFoundException e) {
                // empty catch block
            }
            this.destination.setDLQ(dest);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, " setDLQ");
        }
    }

    public ObjectName getDLQ() {
        return this.dlqObjectName;
    }

    public void setExpiryQueue(ObjectName on) throws Exception {
        this.expiryQueueObjectName = on;
        ManagedQueue dest = null;
        try {
            try {
                dest = (ManagedQueue)JMXAccessor.getJMXAttributeOverSecurity(this.server, this.expiryQueueObjectName, "Instance");
            }
            catch (InstanceNotFoundException e) {
                // empty catch block
            }
            this.destination.setExpiryQueue(dest);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " setExpiryQueue");
        }
    }

    public ObjectName getExpiryQueue() {
        return this.expiryQueueObjectName;
    }

    public long getRedeliveryDelay() {
        return this.destination.getRedeliveryDelay();
    }

    public void setRedeliveryDelay(long delay) {
        this.destination.setRedeliveryDelay(delay);
    }

    public int getMaxSize() {
        return this.destination.getMaxSize();
    }

    private void setMaxSizeForQueues() throws Exception {
        JMSCondition cond = new JMSCondition(this.isQueue(), this.getName());
        PostOffice postOffice = this.serverPeer.getPostOfficeInstance();
        Collection subs = postOffice.getQueuesForCondition(cond, true);
        for (Queue queue : subs) {
            queue.setMaxSize(this.getMaxSize());
        }
    }

    public void setMaxSize(int maxSize) throws Exception {
        this.destination.setMaxSize(maxSize);
        if (this.started) {
            this.setMaxSizeForQueues();
        }
    }

    public Element getSecurityConfig() {
        return this.destination.getSecurityConfig();
    }

    public void setSecurityConfig(Element securityConfig) throws Exception {
        try {
            if (this.started) {
                this.serverPeer.getSecurityManager().setSecurityConfig(this.isQueue(), this.destination.getName(), securityConfig);
            }
            this.destination.setSecurityConfig(securityConfig);
        }
        catch (Throwable t) {
            ExceptionUtil.handleJMXInvocation(t, this + " setSecurityConfig");
        }
    }

    public int getFullSize() {
        return this.destination.getFullSize();
    }

    public void setFullSize(int fullSize) {
        if (this.started) {
            this.log.warn("FullSize can only be changed when destination is stopped");
            return;
        }
        this.destination.setFullSize(fullSize);
    }

    public int getPageSize() {
        return this.destination.getPageSize();
    }

    public void setPageSize(int pageSize) {
        if (this.started) {
            this.log.warn("PageSize can only be changed when destination is stopped");
            return;
        }
        this.destination.setPageSize(pageSize);
    }

    public int getDownCacheSize() {
        return this.destination.getDownCacheSize();
    }

    public void setDownCacheSize(int downCacheSize) {
        if (this.started) {
            this.log.warn("DownCacheSize can only be changed when destination is stopped");
            return;
        }
        this.destination.setDownCacheSize(downCacheSize);
    }

    public boolean isClustered() {
        return this.destination.isClustered();
    }

    public void setClustered(boolean clustered) {
        if (this.started) {
            this.log.warn("Clustered can only be changed when destination is stopped");
            return;
        }
        this.destination.setClustered(clustered);
    }

    public boolean isCreatedProgrammatically() {
        return this.createdProgrammatically;
    }

    public int getMessageCounterHistoryDayLimit() {
        return this.destination.getMessageCounterHistoryDayLimit();
    }

    public void setMessageCounterHistoryDayLimit(int limit) throws Exception {
        this.destination.setMessageCounterHistoryDayLimit(limit);
    }

    public int getMaxDeliveryAttempts() {
        return this.destination.getMaxDeliveryAttempts();
    }

    public void setMaxDeliveryAttempts(int maxDeliveryAttempts) {
        this.destination.setMaxDeliveryAttempts(maxDeliveryAttempts);
    }

    public abstract void removeAllMessages() throws Exception;

    public String toString() {
        String nameFromJNDI = this.destination.getJndiName();
        int idx = -1;
        if (nameFromJNDI != null) {
            idx = nameFromJNDI.lastIndexOf(47);
        }
        if (idx != -1) {
            nameFromJNDI = nameFromJNDI.substring(idx + 1);
        }
        StringBuffer sb = new StringBuffer();
        if (this.isQueue()) {
            sb.append("Queue");
        } else {
            sb.append("Topic");
        }
        sb.append('[');
        if (this.destination == null) {
            sb.append("(NULL Destination)");
        } else if (this.destination.getName() == null) {
            sb.append("(destination.getName() == NULL)");
        } else if (this.destination.getName().equals(nameFromJNDI)) {
            sb.append(this.destination.getJndiName());
        } else {
            sb.append(this.destination.getJndiName()).append(", name=").append(this.destination.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    protected String listMessageCounterAsHTML(MessageCounter[] counters) {
        if (counters == null) {
            return null;
        }
        String ret = "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Type</th><th>Name</th><th>Subscription</th><th>Durable</th><th>Count</th><th>CountDelta</th><th>Depth</th><th>DepthDelta</th><th>Last Add</th></tr>";
        for (int i = 0; i < counters.length; ++i) {
            String data = counters[i].getCounterAsString();
            StringTokenizer token = new StringTokenizer(data, ",");
            ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            String value = token.nextToken();
            if (value.equalsIgnoreCase("0")) {
                value = "-";
            }
            ret = ret + "<td>" + value + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            value = token.nextToken();
            if (value.equalsIgnoreCase("0")) {
                value = "-";
            }
            ret = ret + "<td>" + value + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "</tr>";
        }
        ret = ret + "</table>";
        return ret;
    }

    protected String listMessageCounterHistoryAsHTML(MessageCounter[] counters) {
        if (counters == null) {
            return null;
        }
        String ret = "";
        for (int i = 0; i < counters.length; ++i) {
            ret = ret + (counters[i].getDestinationTopic() ? "Topic '" : "Queue '");
            ret = ret + counters[i].getDestinationName() + "'";
            if (counters[i].getDestinationSubscription() != null) {
                ret = ret + "Subscription '" + counters[i].getDestinationSubscription() + "'";
            }
            ret = ret + "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Date</th>";
            for (int j = 0; j < 24; ++j) {
                ret = ret + "<th width=\"4%\">" + j + "</th>";
            }
            ret = ret + "<th>Total</th></tr>";
            StringTokenizer tokens = new StringTokenizer(counters[i].getHistoryAsString(), ",\n");
            int days = Integer.parseInt(tokens.nextToken());
            for (int j = 0; j < days; ++j) {
                ret = ret + "<tr bgcolor=\"#" + (j % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
                ret = ret + "<td>" + tokens.nextToken() + "</td>";
                int total = 0;
                for (int k = 0; k < 24; ++k) {
                    int value = Integer.parseInt(tokens.nextToken().trim());
                    if (value == -1) {
                        ret = ret + "<td></td>";
                        continue;
                    }
                    ret = ret + "<td>" + value + "</td>";
                    total += value;
                }
                ret = ret + "<td>" + total + "</td></tr>";
            }
            ret = ret + "</table><br><br>";
        }
        return ret;
    }

    protected abstract boolean isQueue();
}

