/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import org.jboss.jms.client.JBossMessageConsumer;
import org.jboss.jms.client.JBossMessageProducer;
import org.jboss.jms.client.JBossQueueBrowser;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.BrowserDelegate;
import org.jboss.jms.delegate.ConsumerDelegate;
import org.jboss.jms.delegate.ProducerDelegate;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.destination.JBossQueue;
import org.jboss.jms.destination.JBossTemporaryQueue;
import org.jboss.jms.destination.JBossTemporaryTopic;
import org.jboss.jms.destination.JBossTopic;
import org.jboss.jms.message.MessageProxy;
import org.jboss.logging.Logger;

public class JBossSession
implements Session,
XASession,
QueueSession,
XAQueueSession,
TopicSession,
XATopicSession,
Serializable {
    private static final long serialVersionUID = 2235942510476264909L;
    static final int TYPE_GENERIC_SESSION = 0;
    static final int TYPE_QUEUE_SESSION = 1;
    static final int TYPE_TOPIC_SESSION = 2;
    private static final Logger log = Logger.getLogger(JBossSession.class);
    protected SessionDelegate delegate;
    protected int sessionType;

    public JBossSession(SessionDelegate sessionDelegate, int sessionType) {
        this.delegate = sessionDelegate;
        this.sessionType = sessionType;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.delegate.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.delegate.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.delegate.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.delegate.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return this.delegate.createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.delegate.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.delegate.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.delegate.createTextMessage(text);
    }

    public boolean getTransacted() throws JMSException {
        return this.delegate.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.delegate.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        this.delegate.commit();
    }

    public void rollback() throws JMSException {
        this.delegate.rollback();
    }

    public void close() throws JMSException {
        this.delegate.closing(-1L);
        this.delegate.close();
    }

    public void recover() throws JMSException {
        this.delegate.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        if (log.isTraceEnabled()) {
            log.trace("getMessageListener() called");
        }
        return this.delegate.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (log.isTraceEnabled()) {
            log.trace("setMessageListener(" + listener + ") called");
        }
        this.delegate.setMessageListener(listener);
    }

    public void run() {
        if (log.isTraceEnabled()) {
            log.trace("run() called");
        }
        this.delegate.run();
    }

    public MessageProducer createProducer(Destination d) throws JMSException {
        if (d != null && !(d instanceof JBossDestination)) {
            throw new InvalidDestinationException("Not a JBossDestination:" + d);
        }
        ProducerDelegate producerDelegate = this.delegate.createProducerDelegate((JBossDestination)d);
        return new JBossMessageProducer(producerDelegate);
    }

    public MessageConsumer createConsumer(Destination d) throws JMSException {
        return this.createConsumer(d, null, false);
    }

    public MessageConsumer createConsumer(Destination d, String messageSelector) throws JMSException {
        return this.createConsumer(d, messageSelector, false);
    }

    public MessageConsumer createConsumer(Destination d, String messageSelector, boolean noLocal) throws JMSException {
        if (d == null) {
            throw new InvalidDestinationException("Cannot create a consumer with a null destination");
        }
        if (!(d instanceof JBossDestination)) {
            throw new InvalidDestinationException("Not a JBossDestination:" + d);
        }
        log.trace("attempting to create consumer for destination:" + d + (messageSelector == null ? "" : ", messageSelector: " + messageSelector) + (noLocal ? ", noLocal = true" : ""));
        ConsumerDelegate cd = this.delegate.createConsumerDelegate((JBossDestination)d, messageSelector, noLocal, null, false, true);
        return new JBossMessageConsumer(cd);
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a queue using a TopicSession");
        }
        return this.delegate.createQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a topic on a QueueSession");
        }
        return this.delegate.createTopic(topicName);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a durable subscriber on a QueueSession");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Cannot create a durable subscriber on a null topic");
        }
        if (!(topic instanceof JBossTopic)) {
            throw new InvalidDestinationException("Not a JBossTopic:" + topic);
        }
        ConsumerDelegate cd = this.delegate.createConsumerDelegate((JBossTopic)topic, null, false, name, false, true);
        return new JBossMessageConsumer(cd);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a durable subscriber on a QueueSession");
        }
        if (topic == null) {
            throw new InvalidDestinationException("Cannot create a durable subscriber on a null topic");
        }
        if (!(topic instanceof JBossTopic)) {
            throw new InvalidDestinationException("Not a JBossTopic:" + topic);
        }
        if ("".equals(messageSelector)) {
            messageSelector = null;
        }
        ConsumerDelegate cd = this.delegate.createConsumerDelegate((JBossTopic)topic, messageSelector, noLocal, name, false, true);
        return new JBossMessageConsumer(cd);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a browser on a TopicSession");
        }
        if (queue == null) {
            throw new InvalidDestinationException("Cannot create a browser with a null queue");
        }
        if (!(queue instanceof JBossQueue)) {
            throw new InvalidDestinationException("Not a JBossQueue:" + queue);
        }
        if ("".equals(messageSelector)) {
            messageSelector = null;
        }
        BrowserDelegate del = this.delegate.createBrowserDelegate((JBossQueue)queue, messageSelector);
        return new JBossQueueBrowser(queue, messageSelector, del);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (this.sessionType == 2) {
            throw new IllegalStateException("Cannot create a temporary queue using a TopicSession");
        }
        JBossTemporaryQueue queue = new JBossTemporaryQueue(this.delegate);
        this.delegate.addTemporaryDestination(queue);
        return queue;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot create a temporary topic on a QueueSession");
        }
        JBossTemporaryTopic topic = new JBossTemporaryTopic(this.delegate);
        this.delegate.addTemporaryDestination(topic);
        return topic;
    }

    public void unsubscribe(String name) throws JMSException {
        if (this.sessionType == 1) {
            throw new IllegalStateException("Cannot unsubscribe using a QueueSession");
        }
        this.delegate.unsubscribe(name);
    }

    public Session getSession() throws JMSException {
        SessionState state = (SessionState)((DelegateSupport)((Object)this.delegate)).getState();
        if (!state.isXA()) {
            throw new IllegalStateException("Isn't an XASession");
        }
        return this;
    }

    public XAResource getXAResource() {
        return this.delegate.getXAResource();
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return (QueueReceiver)this.createConsumer(queue, messageSelector);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return (QueueReceiver)this.createConsumer(queue);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return (QueueSender)this.createProducer(queue);
    }

    public QueueSession getQueueSession() throws JMSException {
        return (QueueSession)this.getSession();
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return (TopicPublisher)this.createProducer(topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)this.createConsumer(topic, messageSelector, noLocal);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return (TopicSubscriber)this.createConsumer(topic);
    }

    public TopicSession getTopicSession() throws JMSException {
        return (TopicSession)this.getSession();
    }

    public String toString() {
        return "JBossSession->" + this.delegate;
    }

    public SessionDelegate getDelegate() {
        return this.delegate;
    }

    void addAsfMessage(MessageProxy m, String consumerID, String queueName, int maxDeliveries, SessionDelegate connectionConsumerSession, boolean shouldAck) {
        this.delegate.addAsfMessage(m, consumerID, queueName, maxDeliveries, connectionConsumerSession, shouldAck);
    }
}

