/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.rmi.ir;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.ClassDesc;
import org.jboss.iiop.rmi.AttributeAnalysis;
import org.jboss.iiop.rmi.ConstantAnalysis;
import org.jboss.iiop.rmi.ContainerAnalysis;
import org.jboss.iiop.rmi.ExceptionAnalysis;
import org.jboss.iiop.rmi.InterfaceAnalysis;
import org.jboss.iiop.rmi.OperationAnalysis;
import org.jboss.iiop.rmi.ParameterAnalysis;
import org.jboss.iiop.rmi.RMIIIOPViolationException;
import org.jboss.iiop.rmi.RmiIdlUtil;
import org.jboss.iiop.rmi.Util;
import org.jboss.iiop.rmi.ValueAnalysis;
import org.jboss.iiop.rmi.ValueMemberAnalysis;
import org.jboss.iiop.rmi.ir.AliasDefImpl;
import org.jboss.iiop.rmi.ir.AttributeDefImpl;
import org.jboss.iiop.rmi.ir.ConstantDefImpl;
import org.jboss.iiop.rmi.ir.ExceptionDefImpl;
import org.jboss.iiop.rmi.ir.IRConstructionException;
import org.jboss.iiop.rmi.ir.InterfaceDefImpl;
import org.jboss.iiop.rmi.ir.LocalContained;
import org.jboss.iiop.rmi.ir.LocalContainer;
import org.jboss.iiop.rmi.ir.ModuleDefImpl;
import org.jboss.iiop.rmi.ir.OperationDefImpl;
import org.jboss.iiop.rmi.ir.RepositoryImpl;
import org.jboss.iiop.rmi.ir.SequenceDefImpl;
import org.jboss.iiop.rmi.ir.ValueBoxDefImpl;
import org.jboss.iiop.rmi.ir.ValueDefImpl;
import org.jboss.iiop.rmi.ir.ValueMemberDefImpl;
import org.jboss.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.DefinitionKind;
import org.omg.CORBA.ExceptionDef;
import org.omg.CORBA.ExceptionDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.PortableServer.POA;

public class InterfaceRepository {
    private static Map primitiveTypeCodeMap;
    private static Map constantTypeCodeMap;
    private static final Logger logger;
    RepositoryImpl impl;
    private ORB orb = null;
    private POA poa = null;
    private Map typeCodeMap = new HashMap(primitiveTypeCodeMap);
    private Map interfaceMap = new HashMap();
    private Map valueMap = new HashMap();
    private Map exceptionMap = new HashMap();
    private Map arrayMap = new HashMap();
    private AliasDefImpl javaIoSerializable = null;
    private AliasDefImpl javaIoExternalizable = null;
    private AliasDefImpl javaLang_Object = null;
    private ValueDefImpl javaLangString = null;
    private ValueDefImpl javaxRmiCORBAClassDesc = null;

    public InterfaceRepository(ORB orb, POA poa, String name) {
        this.orb = orb;
        this.poa = poa;
        this.impl = new RepositoryImpl(orb, poa, name);
    }

    public void mapClass(Class cls) throws RMIIIOPViolationException, IRConstructionException {
        this.getTypeCode(cls);
    }

    public void finishBuild() throws IRConstructionException {
        this.impl.allDone();
    }

    public Repository getReference() {
        return RepositoryHelper.narrow((Object)this.impl.getReference());
    }

    public void shutdown() {
        this.impl.shutdown();
    }

    private TypeCode getConstantTypeCode(Class cls) throws IRConstructionException {
        if (cls == null) {
            throw new IllegalArgumentException("Null class");
        }
        TypeCode ret = (TypeCode)constantTypeCodeMap.get(cls);
        if (ret == null) {
            throw new IRConstructionException("Bad class \"" + cls.getName() + "\" for a constant.");
        }
        return ret;
    }

    private TypeCode getTypeCode(Class cls) throws IRConstructionException, RMIIIOPViolationException {
        if (cls == null) {
            throw new IllegalArgumentException("Null class");
        }
        TypeCode ret = (TypeCode)this.typeCodeMap.get(cls);
        if (ret == null) {
            if (cls == String.class) {
                ret = this.getJavaLangString().type();
            } else if (cls == java.lang.Object.class) {
                ret = this.getJavaLang_Object().type();
            } else if (cls == Class.class) {
                ret = this.getJavaxRmiCORBAClassDesc().type();
            } else if (cls == Serializable.class) {
                ret = this.getJavaIoSerializable().type();
            } else if (cls == Externalizable.class) {
                ret = this.getJavaIoExternalizable().type();
            } else {
                this.addClass(cls);
                ret = (TypeCode)this.typeCodeMap.get(cls);
                if (ret == null) {
                    throw new IRConstructionException("TypeCode for class " + cls.getName() + " unknown.");
                }
                return ret;
            }
            this.typeCodeMap.put(cls, ret);
        }
        return ret;
    }

    private void addTypeCode(Class cls, TypeCode typeCode) throws IRConstructionException {
        if (cls == null) {
            throw new IllegalArgumentException("Null class");
        }
        TypeCode tc = (TypeCode)this.typeCodeMap.get(cls);
        if (tc != null) {
            throw new IllegalArgumentException("Class " + cls.getName() + " already has TypeCode.");
        }
        logger.trace("InterfaceRepository: added typecode for " + cls.getName());
        this.typeCodeMap.put(cls, typeCode);
    }

    private AliasDefImpl getJavaIoSerializable() throws IRConstructionException {
        if (this.javaIoSerializable == null) {
            String id = "IDL:java/io/Serializable:1.0";
            String name = "Serializable";
            String version = "1.0";
            ModuleDefImpl m = this.ensurePackageExists("java.io");
            TypeCode typeCode = this.orb.create_alias_tc("IDL:java/io/Serializable:1.0", "Serializable", this.orb.get_primitive_tc(TCKind.tk_any));
            this.javaIoSerializable = new AliasDefImpl("IDL:java/io/Serializable:1.0", "Serializable", "1.0", (LocalContainer)m, typeCode, this.impl);
            m.add("Serializable", this.javaIoSerializable);
        }
        return this.javaIoSerializable;
    }

    private AliasDefImpl getJavaIoExternalizable() throws IRConstructionException {
        if (this.javaIoExternalizable == null) {
            String id = "IDL:java/io/Externalizable:1.0";
            String name = "Externalizable";
            String version = "1.0";
            ModuleDefImpl m = this.ensurePackageExists("java.io");
            TypeCode typeCode = this.orb.create_alias_tc("IDL:java/io/Externalizable:1.0", "Externalizable", this.orb.get_primitive_tc(TCKind.tk_any));
            this.javaIoExternalizable = new AliasDefImpl("IDL:java/io/Externalizable:1.0", "Externalizable", "1.0", (LocalContainer)m, typeCode, this.impl);
            m.add("Externalizable", this.javaIoExternalizable);
        }
        return this.javaIoExternalizable;
    }

    private AliasDefImpl getJavaLang_Object() throws IRConstructionException {
        if (this.javaLang_Object == null) {
            String id = "IDL:java/lang/_Object:1.0";
            String name = "_Object";
            String version = "1.0";
            ModuleDefImpl m = this.ensurePackageExists("java.lang");
            TypeCode typeCode = this.orb.create_alias_tc("IDL:java/lang/_Object:1.0", "_Object", this.orb.get_primitive_tc(TCKind.tk_any));
            this.javaLang_Object = new AliasDefImpl("IDL:java/lang/_Object:1.0", "_Object", "1.0", (LocalContainer)m, typeCode, this.impl);
            m.add("_Object", this.javaLang_Object);
        }
        return this.javaLang_Object;
    }

    private ValueDefImpl getJavaLangString() throws IRConstructionException {
        if (this.javaLangString == null) {
            ModuleDefImpl m = this.ensurePackageExists("org.omg.CORBA");
            ValueDefImpl val = new ValueDefImpl("IDL:omg.org/CORBA/WStringValue:1.0", "WStringValue", "1.0", m, false, false, new String[0], new String[0], this.orb.get_primitive_tc(TCKind.tk_null), this.impl);
            ValueMemberDefImpl vmdi = new ValueMemberDefImpl("IDL:omg.org/CORBA/WStringValue.data:1.0", "data", "1.0", this.orb.create_wstring_tc(0), true, val, this.impl);
            val.add("data", vmdi);
            m.add("WStringValue", val);
            this.javaLangString = val;
        }
        return this.javaLangString;
    }

    private ValueDefImpl getJavaxRmiCORBAClassDesc() throws IRConstructionException, RMIIIOPViolationException {
        if (this.javaxRmiCORBAClassDesc == null) {
            ValueAnalysis va = ValueAnalysis.getValueAnalysis(ClassDesc.class);
            ValueDefImpl val = this.addValue(va);
            if (!"RMI:javax.rmi.CORBA.ClassDesc:B7C4E3FC9EBDC311:CFBF02CF5294176B".equals(val.id())) {
                logger.debug("Compatibility problem: Class javax.rmi.CORBA.ClassDesc does not conform to the Java(TM) Language to IDL Mapping Specification (01-06-07), section 1.3.5.11.");
            }
            this.javaxRmiCORBAClassDesc = val;
        }
        return this.javaxRmiCORBAClassDesc;
    }

    private ModuleDefImpl ensurePackageExists(String pkgName) throws IRConstructionException {
        return this.ensurePackageExists(this.impl, "", pkgName);
    }

    private ModuleDefImpl ensurePackageExists(LocalContainer c, String previous, String remainder) throws IRConstructionException {
        if ("".equals(remainder)) {
            return (ModuleDefImpl)c;
        }
        int idx = remainder.indexOf(46);
        String base = idx == -1 ? remainder : remainder.substring(0, idx);
        base = Util.javaToIDLName(base);
        previous = previous.equals("") ? base : previous + "/" + base;
        remainder = idx == -1 ? "" : remainder.substring(idx + 1);
        LocalContainer next = null;
        LocalContained contained = c._lookup(base);
        if (contained instanceof LocalContainer) {
            next = (LocalContainer)((java.lang.Object)contained);
        } else if (contained != null) {
            throw new IRConstructionException("Name collision while creating package.");
        }
        if (next == null) {
            String id = "IDL:" + previous + ":1.0";
            ModuleDefImpl m = new ModuleDefImpl(id, base, "1.0", c, this.impl);
            logger.trace("Created module \"" + id + "\".");
            c.add(base, m);
            if (idx == -1) {
                return m;
            }
            next = (LocalContainer)((java.lang.Object)c._lookup(base));
        } else if (next.def_kind() != DefinitionKind.dk_Module) {
            throw new IRConstructionException("Name collision while creating package.");
        }
        return this.ensurePackageExists(next, previous, remainder);
    }

    private void addConstants(LocalContainer container, ContainerAnalysis ca) throws RMIIIOPViolationException, IRConstructionException {
        ConstantAnalysis[] consts = ca.getConstants();
        for (int i = 0; i < consts.length; ++i) {
            String cid = ca.getMemberRepositoryId(consts[i].getJavaName());
            String cName = consts[i].getIDLName();
            Class cls = consts[i].getType();
            logger.trace("Constant[" + i + "] class: " + cls.getName());
            TypeCode typeCode = this.getConstantTypeCode(cls);
            Any value = this.orb.create_any();
            consts[i].insertValue(value);
            logger.trace("Adding constant: " + cid);
            ConstantDefImpl cDef = new ConstantDefImpl(cid, cName, "1.0", typeCode, value, container, this.impl);
            container.add(cName, cDef);
        }
    }

    private void addAttributes(LocalContainer container, ContainerAnalysis ca) throws RMIIIOPViolationException, IRConstructionException {
        AttributeAnalysis[] attrs = ca.getAttributes();
        logger.trace("Attribute count: " + attrs.length);
        for (int i = 0; i < attrs.length; ++i) {
            String aid = ca.getMemberRepositoryId(attrs[i].getJavaName());
            String aName = attrs[i].getIDLName();
            Class cls = attrs[i].getCls();
            logger.trace("Attribute[" + i + "] class: " + cls.getName());
            TypeCode typeCode = this.getTypeCode(cls);
            logger.trace("Adding: " + aid);
            AttributeDefImpl aDef = new AttributeDefImpl(aid, aName, "1.0", attrs[i].getMode(), typeCode, container, this.impl);
            container.add(aName, aDef);
        }
    }

    private void addOperations(LocalContainer container, ContainerAnalysis ca) throws RMIIIOPViolationException, IRConstructionException {
        OperationAnalysis[] ops = ca.getOperations();
        logger.debug("Operation count: " + ops.length);
        for (int i = 0; i < ops.length; ++i) {
            String oName = ops[i].getIDLName();
            String oid = ca.getMemberRepositoryId(oName);
            Class cls = ops[i].getReturnType();
            logger.debug("Operation[" + i + "] return type class: " + cls.getName());
            TypeCode typeCode = this.getTypeCode(cls);
            ParameterAnalysis[] ps = ops[i].getParameters();
            ParameterDescription[] params = new ParameterDescription[ps.length];
            for (int j = 0; j < ps.length; ++j) {
                params[j] = new ParameterDescription(ps[j].getIDLName(), this.getTypeCode(ps[j].getCls()), null, ParameterMode.PARAM_IN);
            }
            ExceptionAnalysis[] exc = ops[i].getMappedExceptions();
            ExceptionDef[] exceptions = new ExceptionDef[exc.length];
            for (int j = 0; j < exc.length; ++j) {
                ExceptionDefImpl e = this.addException(exc[j]);
                exceptions[j] = ExceptionDefHelper.narrow((Object)e.getReference());
            }
            logger.debug("Adding: " + oid);
            OperationDefImpl oDef = new OperationDefImpl(oid, oName, "1.0", container, typeCode, params, exceptions, this.impl);
            container.add(oName, oDef);
        }
    }

    private String[] addInterfaces(ContainerAnalysis ca) throws RMIIIOPViolationException, IRConstructionException {
        logger.trace("Adding interfaces: ");
        InterfaceAnalysis[] interfaces = ca.getInterfaces();
        ArrayList<String> base_interfaces = new ArrayList<String>();
        for (int i = 0; i < interfaces.length; ++i) {
            InterfaceDefImpl idi = this.addInterface(interfaces[i]);
            base_interfaces.add(idi.id());
            logger.trace("                   " + idi.id());
        }
        String[] strArr = new String[base_interfaces.size()];
        return base_interfaces.toArray(strArr);
    }

    private String[] addAbstractBaseValuetypes(ContainerAnalysis ca) throws RMIIIOPViolationException, IRConstructionException {
        logger.trace("Adding abstract valuetypes: ");
        ValueAnalysis[] abstractValuetypes = ca.getAbstractBaseValuetypes();
        ArrayList<String> abstract_base_valuetypes = new ArrayList<String>();
        for (int i = 0; i < abstractValuetypes.length; ++i) {
            ValueDefImpl vdi = this.addValue(abstractValuetypes[i]);
            abstract_base_valuetypes.add(vdi.id());
            logger.trace("                   " + vdi.id());
        }
        String[] strArr = new String[abstract_base_valuetypes.size()];
        return abstract_base_valuetypes.toArray(strArr);
    }

    private void addClass(Class cls) throws RMIIIOPViolationException, IRConstructionException {
        if (cls.isPrimitive()) {
            return;
        }
        if (cls.isArray()) {
            this.addArray(cls);
        } else if (cls.isInterface()) {
            if (!RmiIdlUtil.isAbstractValueType(cls)) {
                InterfaceAnalysis ia = InterfaceAnalysis.getInterfaceAnalysis(cls);
                this.addInterface(ia);
            } else {
                ValueAnalysis va = ValueAnalysis.getValueAnalysis(cls);
                this.addValue(va);
            }
        } else if (Exception.class.isAssignableFrom(cls)) {
            ExceptionAnalysis ea = ExceptionAnalysis.getExceptionAnalysis(cls);
            this.addException(ea);
        } else {
            ValueAnalysis va = ValueAnalysis.getValueAnalysis(cls);
            this.addValue(va);
        }
    }

    private ValueBoxDefImpl addArray(Class cls) throws RMIIIOPViolationException, IRConstructionException {
        int i;
        String moduleName;
        TypeCode typeCode;
        String typeName;
        if (!cls.isArray()) {
            throw new IllegalArgumentException("Not an array class.");
        }
        ValueBoxDefImpl vbDef = (ValueBoxDefImpl)this.arrayMap.get(cls);
        if (vbDef != null) {
            return vbDef;
        }
        int dimensions = 0;
        Class<?> compType = cls;
        do {
            compType = compType.getComponentType();
            ++dimensions;
        } while (compType.isArray());
        if (compType.isPrimitive()) {
            if (compType == Boolean.TYPE) {
                typeName = "boolean";
                typeCode = this.orb.get_primitive_tc(TCKind.tk_boolean);
            } else if (compType == Character.TYPE) {
                typeName = "wchar";
                typeCode = this.orb.get_primitive_tc(TCKind.tk_wchar);
            } else if (compType == Byte.TYPE) {
                typeName = "octet";
                typeCode = this.orb.get_primitive_tc(TCKind.tk_octet);
            } else if (compType == Short.TYPE) {
                typeName = "short";
                typeCode = this.orb.get_primitive_tc(TCKind.tk_short);
            } else if (compType == Integer.TYPE) {
                typeName = "long";
                typeCode = this.orb.get_primitive_tc(TCKind.tk_long);
            } else if (compType == Long.TYPE) {
                typeName = "long_long";
                typeCode = this.orb.get_primitive_tc(TCKind.tk_longlong);
            } else if (compType == Float.TYPE) {
                typeName = "float";
                typeCode = this.orb.get_primitive_tc(TCKind.tk_float);
            } else if (compType == Double.TYPE) {
                typeName = "double";
                typeCode = this.orb.get_primitive_tc(TCKind.tk_double);
            } else {
                throw new IRConstructionException("Unknown primitive type for array type: " + cls.getName());
            }
            moduleName = "org.omg.boxedRMI";
        } else {
            typeCode = this.getTypeCode(compType);
            typeName = compType == String.class ? this.getJavaLangString().name() : (compType == java.lang.Object.class ? this.getJavaLang_Object().name() : (compType == Class.class ? this.getJavaxRmiCORBAClassDesc().name() : (compType == Serializable.class ? this.getJavaIoSerializable().name() : (compType == Externalizable.class ? this.getJavaIoExternalizable().name() : (compType.isInterface() && !RmiIdlUtil.isAbstractValueType(compType) ? ((InterfaceDefImpl)this.interfaceMap.get(compType)).name() : (Exception.class.isAssignableFrom(compType) ? ((ExceptionDefImpl)this.exceptionMap.get(compType)).name() : ((ValueDefImpl)this.valueMap.get(compType)).name()))))));
            moduleName = "org.omg.boxedRMI." + compType.getPackage().getName();
        }
        ModuleDefImpl m = this.ensurePackageExists(moduleName);
        Class[] types = new Class[dimensions];
        types[dimensions - 1] = cls;
        for (i = dimensions - 2; i >= 0; --i) {
            types[i] = types[i + 1].getComponentType();
        }
        for (i = 0; i < dimensions; ++i) {
            Class type = types[i];
            typeCode = this.orb.create_sequence_tc(0, typeCode);
            vbDef = (ValueBoxDefImpl)this.arrayMap.get(type);
            if (vbDef == null) {
                String id = Util.getIRIdentifierOfClass(type);
                SequenceDefImpl sdi = new SequenceDefImpl(typeCode, this.impl);
                String name = "seq" + (i + 1) + "_" + typeName;
                TypeCode boxTypeCode = this.orb.create_value_box_tc(id, name, typeCode);
                vbDef = new ValueBoxDefImpl(id, name, "1.0", (LocalContainer)m, boxTypeCode, this.impl);
                this.addTypeCode(type, vbDef.type());
                m.add(name, vbDef);
                this.impl.putSequenceImpl(id, typeCode, sdi, vbDef);
                this.arrayMap.put(type, vbDef);
                typeCode = boxTypeCode;
                continue;
            }
            typeCode = vbDef.type();
        }
        return vbDef;
    }

    private InterfaceDefImpl addInterface(InterfaceAnalysis ia) throws RMIIIOPViolationException, IRConstructionException {
        Class cls = ia.getCls();
        InterfaceDefImpl iDef = (InterfaceDefImpl)this.interfaceMap.get(cls);
        if (iDef != null) {
            return iDef;
        }
        if (ia.isAbstractInterface()) {
            logger.trace("Adding abstract interface: " + ia.getRepositoryId());
        }
        ModuleDefImpl m = this.ensurePackageExists(cls.getPackage().getName());
        String[] base_interfaces = this.addInterfaces(ia);
        String base = cls.getName();
        base = base.substring(base.lastIndexOf(46) + 1);
        base = Util.javaToIDLName(base);
        iDef = new InterfaceDefImpl(ia.getRepositoryId(), base, "1.0", (LocalContainer)m, base_interfaces, this.impl);
        this.addTypeCode(cls, iDef.type());
        m.add(base, iDef);
        this.interfaceMap.put(cls, iDef);
        this.addConstants(iDef, ia);
        this.addAttributes(iDef, ia);
        this.addOperations(iDef, ia);
        logger.trace("Added interface: " + ia.getRepositoryId());
        return iDef;
    }

    private ValueDefImpl addValue(ValueAnalysis va) throws RMIIIOPViolationException, IRConstructionException {
        Class cls = va.getCls();
        ValueDefImpl vDef = (ValueDefImpl)this.valueMap.get(cls);
        if (vDef != null) {
            return vDef;
        }
        ModuleDefImpl m = this.ensurePackageExists(cls.getPackage().getName());
        String[] supported_interfaces = this.addInterfaces(va);
        String[] abstract_base_valuetypes = this.addAbstractBaseValuetypes(va);
        ValueDefImpl superValue = null;
        ValueAnalysis superAnalysis = va.getSuperAnalysis();
        if (superAnalysis != null) {
            superValue = this.addValue(superAnalysis);
        }
        String base = cls.getName();
        base = base.substring(base.lastIndexOf(46) + 1);
        base = Util.javaToIDLName(base);
        TypeCode baseTypeCode = superValue == null ? this.orb.get_primitive_tc(TCKind.tk_null) : superValue.type();
        vDef = new ValueDefImpl(va.getRepositoryId(), base, "1.0", m, va.isAbstractValue(), va.isCustom(), supported_interfaces, abstract_base_valuetypes, baseTypeCode, this.impl);
        this.addTypeCode(cls, vDef.type());
        logger.debug("Value: base=" + base);
        m.add(base, vDef);
        this.valueMap.put(cls, vDef);
        this.addConstants(vDef, va);
        ValueMemberAnalysis[] vmas = va.getMembers();
        logger.debug("Value member count: " + vmas.length);
        for (int i = 0; i < vmas.length; ++i) {
            String vmid = va.getMemberRepositoryId(vmas[i].getJavaName());
            String vmName = vmas[i].getIDLName();
            Class vmCls = vmas[i].getCls();
            logger.debug("ValueMembers[" + i + "] class: " + vmCls.getName());
            TypeCode typeCode = this.getTypeCode(vmCls);
            boolean vmPublic = vmas[i].isPublic();
            logger.debug("Adding value member: " + vmid);
            ValueMemberDefImpl vmDef = new ValueMemberDefImpl(vmid, vmName, "1.0", typeCode, vmPublic, vDef, this.impl);
            vDef.add(vmName, vmDef);
        }
        this.addAttributes(vDef, va);
        return vDef;
    }

    private ExceptionDefImpl addException(ExceptionAnalysis ea) throws RMIIIOPViolationException, IRConstructionException {
        Class cls = ea.getCls();
        ExceptionDefImpl eDef = (ExceptionDefImpl)this.exceptionMap.get(cls);
        if (eDef != null) {
            return eDef;
        }
        ValueDefImpl vDef = this.addValue(ea);
        ModuleDefImpl m = this.ensurePackageExists(cls.getPackage().getName());
        String base = cls.getName();
        if ((base = base.substring(base.lastIndexOf(46) + 1)).endsWith("Exception")) {
            base = base.substring(0, base.length() - 9);
        }
        base = Util.javaToIDLName(base + "Ex");
        StructMember[] members = new StructMember[]{new StructMember("value", vDef.type(), null)};
        TypeCode typeCode = this.orb.create_exception_tc(ea.getExceptionRepositoryId(), base, members);
        eDef = new ExceptionDefImpl(ea.getExceptionRepositoryId(), base, "1.0", typeCode, vDef, m, this.impl);
        logger.debug("Exception: base=" + base);
        m.add(base, eDef);
        this.exceptionMap.put(cls, eDef);
        return eDef;
    }

    static {
        ORB orb;
        try {
            orb = (ORB)new InitialContext().lookup("java:/JBossCorbaORB");
        }
        catch (NamingException ex) {
            throw new RuntimeException("Cannot lookup java:/JBossCorbaORB: " + ex);
        }
        primitiveTypeCodeMap = new HashMap();
        primitiveTypeCodeMap.put(Void.TYPE, orb.get_primitive_tc(TCKind.tk_void));
        primitiveTypeCodeMap.put(Boolean.TYPE, orb.get_primitive_tc(TCKind.tk_boolean));
        primitiveTypeCodeMap.put(Character.TYPE, orb.get_primitive_tc(TCKind.tk_wchar));
        primitiveTypeCodeMap.put(Byte.TYPE, orb.get_primitive_tc(TCKind.tk_octet));
        primitiveTypeCodeMap.put(Short.TYPE, orb.get_primitive_tc(TCKind.tk_short));
        primitiveTypeCodeMap.put(Integer.TYPE, orb.get_primitive_tc(TCKind.tk_long));
        primitiveTypeCodeMap.put(Long.TYPE, orb.get_primitive_tc(TCKind.tk_longlong));
        primitiveTypeCodeMap.put(Float.TYPE, orb.get_primitive_tc(TCKind.tk_float));
        primitiveTypeCodeMap.put(Double.TYPE, orb.get_primitive_tc(TCKind.tk_double));
        constantTypeCodeMap = new HashMap(primitiveTypeCodeMap);
        constantTypeCodeMap.put(String.class, orb.create_wstring_tc(0));
        logger = Logger.getLogger(InterfaceRepository.class);
    }
}

