/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.jacorb;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.SocketFactory;
import org.jboss.iiop.CorbaORBService;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;
import org.jboss.security.ssl.DomainSocketFactory;
import org.jboss.system.Registry;

public class SSLSocketFactory
implements SocketFactory,
Configurable {
    private static Logger log = Logger.getLogger(SSLSocketFactory.class);
    private DomainSocketFactory domainFactory = null;

    public SSLSocketFactory(ORB orb) throws IOException {
        log.info("Creating");
        SecurityDomain securityDomain = (SecurityDomain)Registry.lookup(CorbaORBService.SSL_DOMAIN);
        try {
            this.domainFactory = new DomainSocketFactory(securityDomain);
        }
        catch (IOException e) {
            log.warn("Could not create DomainSocketFactory: " + e);
            log.debug("Exception creating DomainSockedFactory: ", e);
            throw e;
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.domainFactory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, int timeout) throws IOException, UnknownHostException {
        return this.domainFactory.createSocket(host, port, timeout);
    }

    public boolean isSSL(Socket s) {
        return s instanceof SSLSocket;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
    }
}

