/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.util.HashSet;
import javax.annotation.security.RunAs;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.security.PerClassAspectFactoryAdaptor;
import org.jboss.ejb3.security.RunAsSecurityInterceptorv2;
import org.jboss.ejb3.security.SecurityDomainManager;
import org.jboss.ejb3.tx.NullInterceptor;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;

public class RunAsSecurityInterceptorFactory
extends PerClassAspectFactoryAdaptor
implements AspectFactory {
    private static final Logger log = Logger.getLogger(RunAsSecurityInterceptorFactory.class);

    protected RunAsIdentity getRunAsIdentity(EJBContainer container) {
        RunAs runAs = (RunAs)container.resolveAnnotation(RunAs.class);
        if (runAs == null) {
            return null;
        }
        String runAsPrincipal = runAs.value();
        HashSet<String> extraRoles = new HashSet<String>();
        JBossAssemblyDescriptorMetaData ad = container.getAssemblyDescriptor();
        if (ad != null && runAsPrincipal != null) {
            extraRoles.addAll(ad.getSecurityRoleNamesByPrincipal(runAsPrincipal));
        }
        return new RunAsIdentity(runAs.value(), runAsPrincipal, extraRoles);
    }

    public Object createPerClass(Advisor advisor) {
        EJBContainer container = (EJBContainer)advisor;
        RunAsIdentity runAsIdentity = this.getRunAsIdentity(container);
        Object domain = null;
        try {
            InitialContext ctx = container.getInitialContext();
            SecurityDomain securityDomain = (SecurityDomain)advisor.resolveAnnotation(SecurityDomain.class);
            if (securityDomain != null) {
                String domainName = securityDomain.value();
                domain = SecurityDomainManager.getSecurityManager(domainName, ctx);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        Interceptor interceptor = new NullInterceptor();
        if (domain != null) {
            AuthenticationManager manager = (AuthenticationManager)domain;
            RealmMapping mapping = (RealmMapping)domain;
            interceptor = new RunAsSecurityInterceptorv2(container, this.getRunAsIdentity(container));
        }
        return interceptor;
    }
}

