/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJBAccessException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.security.SecurityActions;
import org.jboss.ejb3.security.SecurityHelper;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.remoting.InvokerLocator;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.integration.ejb.EJBAuthorizationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoleBasedAuthorizationInterceptorv2
implements Interceptor {
    private static final Logger log = Logger.getLogger(RoleBasedAuthorizationInterceptorv2.class);
    private EJBContainer container;
    private CodeSource ejbCS;
    private String ejbName;

    public RoleBasedAuthorizationInterceptorv2(Container container, CodeSource ejbCS, String ejbName) {
        this.container = (EJBContainer)container;
        this.ejbCS = ejbCS;
        this.ejbName = ejbName;
    }

    protected Set<Principal> getRoleSet(Invocation invocation) {
        Method method = ((MethodInvocation)invocation).getActualMethod();
        Class[] classes = new Class[]{DenyAll.class, PermitAll.class, RolesAllowed.class};
        Object annotation = this.container.resolveAnnotation(method, classes);
        int classIndex = 0;
        while (annotation == null && classIndex < 3) {
            annotation = this.container.resolveAnnotation(classes[classIndex++]);
        }
        HashSet<Principal> set = new HashSet<Principal>();
        if (annotation != null) {
            if (annotation instanceof DenyAll) {
                set.add(NobodyPrincipal.NOBODY_PRINCIPAL);
            } else if (annotation instanceof PermitAll) {
                set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
            } else if (annotation instanceof RolesAllowed) {
                RolesAllowed permissions = (RolesAllowed)annotation;
                for (int i = 0; i < permissions.value().length; ++i) {
                    set.add(new SimplePrincipal(permissions.value()[i]));
                }
            } else {
                set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
            }
        } else {
            set.add(AnybodyPrincipal.ANYBODY_PRINCIPAL);
        }
        return set;
    }

    @Override
    public Object invoke(Invocation invocation) throws Throwable {
        SecurityHelper shelper = new SecurityHelper();
        MethodInvocation mi = (MethodInvocation)invocation;
        Method method = mi.getMethod();
        if (shelper.isEJBTimeOutCallback(method) || shelper.containsTimeoutAnnotation(this.container, method) || shelper.isMDB(this.container)) {
            return invocation.invokeNext();
        }
        try {
            boolean domainExists;
            SecurityDomain domain = (SecurityDomain)this.container.resolveAnnotation(SecurityDomain.class);
            boolean bl = domainExists = domain != null && domain.value() != null && domain.value().length() > 0;
            if (domainExists) {
                InvokerLocator locator;
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context has not been set");
                }
                Set<Principal> methodRoles = this.getRoleSet(invocation);
                if (methodRoles == null) {
                    String message = "No method permissions assigned.";
                    log.error(message);
                    throw new SecurityException(message);
                }
                JBossAssemblyDescriptorMetaData jmd = this.container.getAssemblyDescriptor();
                if (jmd != null) {
                    Map<String, Set<String>> principalRoleMap = jmd.getPrincipalVersusRolesMap();
                    SecurityRolesAssociation.setSecurityRoles(principalRoleMap);
                }
                String iface = (locator = (InvokerLocator)invocation.getMetaData("REMOTING", "INVOKER_LOCATOR")) != null ? "Remote" : "Local";
                RunAsIdentity callerRunAs = SecurityActions.peekRunAsIdentity();
                EJBAuthorizationHelper helper = new EJBAuthorizationHelper(sc);
                boolean isAuthorized = helper.authorize(this.ejbName, mi.getMethod(), sc.getUtil().getUserPrincipal(), iface, this.ejbCS, sc.getUtil().getSubject(), callerRunAs, methodRoles);
                if (!isAuthorized) {
                    throw new EJBAccessException("Caller unauthorized");
                }
            }
            Object object = invocation.invokeNext();
            return object;
        }
        catch (SecurityException throwable) {
            log.debug("Authorization failure", throwable);
            throw new EJBAccessException("Authorization failure");
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

