/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.lang.reflect.Method;
import java.security.Principal;
import javax.ejb.EJBAccessException;
import javax.security.auth.Subject;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.security.SecurityActions;
import org.jboss.ejb3.security.SecurityHelper;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityIdentity;
import org.jboss.security.SecurityUtil;
import org.jboss.security.integration.JNDIBasedSecurityManagement;
import org.jboss.security.integration.ejb.EJBAuthenticationHelper;

public class Ejb3AuthenticationInterceptorv2
implements Interceptor {
    protected Logger log = Logger.getLogger(this.getClass());
    private EJBContainer container;

    public Ejb3AuthenticationInterceptorv2(Container container) {
        this.container = (EJBContainer)container;
    }

    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        boolean domainExists;
        SecurityHelper shelper = new SecurityHelper();
        MethodInvocation mi = (MethodInvocation)invocation;
        Method method = mi.getMethod();
        if (shelper.isEJBTimeOutCallback(method) || shelper.containsTimeoutAnnotation(this.container, method) || shelper.isMDB(this.container)) {
            return invocation.invokeNext();
        }
        SecurityIdentity si = null;
        SecurityContext sc = SecurityActions.getSecurityContext();
        SecurityContext invSC = (SecurityContext)invocation.getMetaData("security", "context");
        SecurityDomain domain = (SecurityDomain)this.container.resolveAnnotation(SecurityDomain.class);
        boolean bl = domainExists = domain != null && domain.value() != null && domain.value().length() > 0;
        if (domainExists) {
            Principal p = null;
            Object cred = null;
            if (sc == null && invSC == null) {
                sc = SecurityActions.createSecurityContext(domain.value());
                SecurityActions.setSecurityContext(sc);
            }
            if (shelper.isLocalCall(mi)) {
                if (sc == null) {
                    throw new IllegalStateException("Security Context null on Local call");
                }
                si = sc.getUtil().getSecurityIdentity();
            } else {
                if (invSC == null && sc == null) {
                    throw new IllegalStateException("Security Context is not available");
                }
                if (invSC != null) {
                    sc = invSC;
                    p = sc.getUtil().getUserPrincipal();
                    cred = sc.getUtil().getCredential();
                    String unprefixed = SecurityUtil.unprefixSecurityDomain(domain.value());
                    sc = SecurityActions.createSecurityContext(p, cred, null, unprefixed);
                    SecurityActions.setSecurityContext(sc);
                    sc.getUtil().setSecurityIdentity(invSC.getUtil().getSecurityIdentity());
                }
            }
            sc = SecurityActions.getSecurityContext();
            sc.setSecurityManagement(new JNDIBasedSecurityManagement());
            EJBAuthenticationHelper helper = new EJBAuthenticationHelper(sc);
            boolean trustedCaller = helper.isTrusted();
            if (!trustedCaller) {
                Subject subject = new Subject();
                if (!helper.isValid(subject, method.getName())) {
                    throw new EJBAccessException("Invalid User");
                }
                helper.pushSubjectContext(subject);
            }
        } else if (invSC != null) {
            SecurityActions.setSecurityContext(invSC);
        }
        try {
            if (sc != null) {
                SecurityActions.pushCallerRunAsIdentity(sc.getOutgoingRunAs());
            }
            Object object = invocation.invokeNext();
            if (shelper.isLocalCall(mi) && si != null) {
                SecurityActions.getSecurityContext().getUtil().setSecurityIdentity(si);
            }
            return object;
        }
        catch (Throwable throwable) {
            if (shelper.isLocalCall(mi) && si != null) {
                SecurityActions.getSecurityContext().getUtil().setSecurityIdentity(si);
            }
            throw throwable;
        }
    }
}

