/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBAccessException;
import javax.security.auth.Subject;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.security.AuthenticationInterceptor;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.security.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.plugins.SecurityContextAssociation;

public class Ejb3AuthenticationInterceptor
extends AuthenticationInterceptor {
    private static final Logger log = Logger.getLogger(Ejb3AuthenticationInterceptor.class);
    private EJBContainer container;
    protected RealmMapping realmMapping;
    private AuthenticationInterceptor unauthenticatedAuthenticationInterceptor;

    public Ejb3AuthenticationInterceptor(final AuthenticationManager manager, Container container) {
        super(manager);
        this.container = (EJBContainer)container;
        this.realmMapping = (RealmMapping)((Object)manager);
        this.unauthenticatedAuthenticationInterceptor = new AuthenticationInterceptor(null){

            protected void authenticate(Invocation invocation) throws Exception {
                super.authenticate(invocation);
                if (manager != null) {
                    Principal principal = (Principal)invocation.getMetaData("security", "principal");
                    Subject subject = new Subject();
                    String securityDomain = manager.getSecurityDomain();
                    SecurityContext sc = SecurityActions.createSecurityContext(principal, null, subject, securityDomain);
                    SecurityContextAssociation.setSecurityContext(sc);
                }
            }
        };
    }

    protected void handleGeneralSecurityException(GeneralSecurityException gse) {
        log.debug("Authentication failure", gse);
        throw new EJBAccessException("Authentication failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        SecurityDomain domain = (SecurityDomain)this.container.resolveAnnotation(SecurityDomain.class);
        if (domain != null && domain.unauthenticatedPrincipal() != null && domain.unauthenticatedPrincipal().length() != 0) {
            Principal principal = (Principal)invocation.getMetaData("security", "principal");
            if (principal == null) {
                principal = SecurityAssociation.getPrincipal();
            }
            if (principal == null) {
                principal = new TrustedPrincipal(domain.unauthenticatedPrincipal());
                invocation.getMetaData().addMetaData("security", "principal", principal);
            }
            if (principal != null && principal instanceof TrustedPrincipal) {
                return this.unauthenticatedAuthenticationInterceptor.invoke(invocation);
            }
        }
        try {
            if (this.container.getAssemblyDescriptor() != null) {
                Map<String, Set<String>> securityRoles = null;
                SecurityRolesAssociation.setSecurityRoles(securityRoles);
            }
            Object object = super.invoke(invocation);
            return object;
        }
        finally {
            SecurityRolesAssociation.setSecurityRoles(null);
        }
    }

    class TrustedPrincipal
    extends SimplePrincipal {
        private static final long serialVersionUID = 1L;

        public TrustedPrincipal(String name) {
            super(name);
        }
    }
}

