/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.security;

import org.jboss.aop.Advisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.security.Ejb3AuthenticationInterceptorv2;
import org.jboss.ejb3.security.PerClassAspectFactoryAdaptor;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;

public class AuthenticationInterceptorFactory
extends PerClassAspectFactoryAdaptor
implements AspectFactory {
    private static final Logger log = Logger.getLogger(AuthenticationInterceptorFactory.class);

    public Object createPerClass(Advisor advisor) {
        Container container = (Container)((Object)advisor);
        AuthenticationManager manager = container.getSecurityManager(AuthenticationManager.class);
        log.debug("Creating interceptor with authentication manager '" + manager + "'" + (manager != null ? " (security domain '" + manager.getSecurityDomain() + "')" : ""));
        return new Ejb3AuthenticationInterceptorv2(container);
    }
}

