/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.lang;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassHelper {
    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    private static Method findPrivateMethod(Class<?> target, String methodName, Class<?> ... paramTypes) {
        if (target == null) {
            return null;
        }
        for (Method method : target.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            if (paramTypes == null) {
                return method;
            }
            if (!Arrays.equals(method.getParameterTypes(), paramTypes)) continue;
            return method;
        }
        return ClassHelper.findPrivateMethod(target.getSuperclass(), methodName, paramTypes);
    }

    public static List<Method> getAllMethodsByName(Class<?> cls, String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassHelper.populateWithMethodsByName(methods, cls, methodName);
        return methods;
    }

    public static List<Method> getAllMethodsByPrefix(Class<?> clazz, String methodNamePrefix) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassHelper.populateWithMethodsByPrefix(methods, clazz, methodNamePrefix);
        return methods;
    }

    public static Method getPrivateMethod(Class<?> cls, String methodName, Class<?> ... paramTypes) throws NoSuchMethodException {
        assert (cls != null) : "cls is null";
        assert (methodName != null) : "methodName is null";
        Method result = ClassHelper.findPrivateMethod(cls, methodName, paramTypes);
        if (result == null) {
            throw new NoSuchMethodException(cls.getName() + "." + methodName + ClassHelper.argumentTypesToString(paramTypes));
        }
        return result;
    }

    private static void populateWithMethodsByName(List<Method> methods, Class<?> cls, String methodName) {
        if (cls == null) {
            return;
        }
        for (Method method : cls.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            methods.add(method);
        }
        ClassHelper.populateWithMethodsByName(methods, cls.getSuperclass(), methodName);
    }

    private static void populateWithMethodsByPrefix(List<Method> methods, Class<?> clazz, String methodNamePrefix) {
        if (clazz == null) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().startsWith(methodNamePrefix)) continue;
            methods.add(method);
        }
        ClassHelper.populateWithMethodsByPrefix(methods, clazz.getSuperclass(), methodNamePrefix);
    }
}

