/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.persistence;

import java.util.Map;
import org.jboss.ejb3.cache.persistence.PersistenceManagerFactory;
import org.jboss.ejb3.cache.persistence.PersistenceManagerFactoryNotRegisteredException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManagerFactoryRegistry {
    private Map<String, Class<? extends PersistenceManagerFactory>> factories;

    public Map<String, Class<? extends PersistenceManagerFactory>> getFactories() {
        return this.factories;
    }

    public void setFactories(Map<String, Class<? extends PersistenceManagerFactory>> factories) {
        this.factories = factories;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory(String name) throws PersistenceManagerFactoryNotRegisteredException {
        Class<? extends PersistenceManagerFactory> persistenceManagerFactory = this.factories.get(name);
        if (persistenceManagerFactory == null) {
            throw new PersistenceManagerFactoryNotRegisteredException("PersistenceManager Factory with name " + name + " is not registered.");
        }
        try {
            return persistenceManagerFactory.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error in instanciating persistence manager factory " + persistenceManagerFactory.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

