/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.io.Serializable;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TimerHandle;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.txtimer.TimedObjectInvoker;
import org.jboss.ejb.txtimer.TimerHandleImpl;
import org.jboss.ejb.txtimer.TimerServiceImpl;
import org.jboss.logging.Logger;

public class TimerImpl
implements javax.ejb.Timer,
Synchronization {
    private static Logger log = Logger.getLogger(TimerImpl.class);
    private static final int CREATED = 0;
    private static final int STARTED_IN_TX = 1;
    private static final int ACTIVE = 2;
    private static final int CANCELED_IN_TX = 3;
    private static final int CANCELED = 4;
    private static final int EXPIRED = 5;
    private static final int IN_TIMEOUT = 6;
    private static final int RETRY_TIMEOUT = 7;
    private static final String[] TIMER_STATES = new String[]{"created", "started_in_tx", "active", "canceled_in_tx", "canceled", "expired", "in_timeout", "retry_timeout"};
    private TimerServiceImpl timerService;
    private String timerId;
    private TimedObjectId timedObjectId;
    private TimedObjectInvoker timedObjectInvoker;
    private Date firstTime;
    private long periode;
    private Serializable info;
    private long nextExpire;
    private int timerState;
    private Timer utilTimer;
    private int hashCode;

    TimerImpl(TimerServiceImpl timerService, String timerId, TimedObjectId timedObjectId, TimedObjectInvoker timedObjectInvoker, Serializable info) {
        this.timerService = timerService;
        this.timerId = timerId;
        this.timedObjectId = timedObjectId;
        this.timedObjectInvoker = timedObjectInvoker;
        this.info = info;
        this.setTimerState(0);
    }

    void startTimer(Date firstTime, long periode) {
        this.firstTime = firstTime;
        this.nextExpire = firstTime.getTime();
        this.periode = periode;
        this.timerService.addTimer(this);
        this.registerTimerWithTx();
        this.startInTx();
    }

    public String getTimerId() {
        return this.timerId;
    }

    public TimedObjectId getTimedObjectId() {
        return this.timedObjectId;
    }

    public Date getFirstTime() {
        return this.firstTime;
    }

    public long getPeriode() {
        return this.periode;
    }

    public long getNextExpire() {
        return this.nextExpire;
    }

    public Serializable getInfoInternal() {
        return this.info;
    }

    public boolean isActive() {
        return !this.isCanceled() && !this.isExpired();
    }

    public boolean isInRetry() {
        return this.timerState == 7;
    }

    public boolean isCanceled() {
        return this.timerState == 3 || this.timerState == 4;
    }

    public boolean isExpired() {
        return this.timerState == 5;
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimedOut();
        this.assertAllowedOperation("Timer.cancel");
        this.registerTimerWithTx();
        this.cancelInTx();
    }

    public void killTimer() {
        log.debug("killTimer: " + this);
        if (this.timerState != 5) {
            this.setTimerState(4);
        }
        this.timerService.removeTimer(this);
        this.utilTimer.cancel();
    }

    private void cancelTimer() {
        if (this.timerState != 5) {
            this.setTimerState(4);
        }
        this.utilTimer.cancel();
    }

    public void stopTimer() {
        log.debug("stopTimer: " + this);
        if (this.timerState != 5) {
            this.setTimerState(4);
        }
        this.utilTimer.cancel();
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimedOut();
        this.assertAllowedOperation("Timer.getTimeRemaining");
        return this.nextExpire - System.currentTimeMillis();
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimedOut();
        this.assertAllowedOperation("Timer.getNextTimeout");
        return new Date(this.nextExpire);
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimedOut();
        this.assertAllowedOperation("Timer.getInfo");
        return this.info;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        this.assertTimedOut();
        this.assertAllowedOperation("Timer.getHandle");
        return new TimerHandleImpl(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TimerImpl) {
            TimerImpl other = (TimerImpl)obj;
            return this.hashCode() == other.hashCode();
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            String hash = "[" + this.timerId + "," + this.timedObjectId + "," + this.firstTime + "," + this.periode + "]";
            this.hashCode = hash.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        long remaining = this.nextExpire - System.currentTimeMillis();
        String retStr = "[id=" + this.timerId + ",target=" + this.timedObjectId + ",remaining=" + remaining + ",periode=" + this.periode + "," + TIMER_STATES[this.timerState] + "]";
        return retStr;
    }

    private void registerTimerWithTx() {
        Transaction tx = this.timerService.getTransaction();
        if (tx != null) {
            try {
                tx.registerSynchronization(this);
            }
            catch (Exception e) {
                log.error("Cannot register txtimer with Tx: " + this);
            }
        }
    }

    private void setTimerState(int state) {
        log.debug("setTimerState: " + TIMER_STATES[state]);
        this.timerState = state;
    }

    private void startInTx() {
        this.utilTimer = new Timer("EJB-Timer-" + this.timerId + this.timedObjectId);
        if (this.timerService.getTransaction() != null) {
            this.setTimerState(1);
        } else {
            this.scheduleTimeout();
            this.setTimerState(2);
        }
    }

    private void cancelInTx() {
        if (this.timerService.getTransaction() != null) {
            this.setTimerState(3);
        } else {
            this.killTimer();
        }
    }

    private void scheduleTimeout() {
        if (this.periode > 0L) {
            this.utilTimer.schedule((TimerTask)new TimerTaskImpl(this), new Date(this.nextExpire), this.periode);
        } else {
            this.utilTimer.schedule((TimerTask)new TimerTaskImpl(this), new Date(this.nextExpire));
        }
    }

    private void assertTimedOut() {
        if (this.timerState == 5) {
            throw new NoSuchObjectLocalException("Timer has expired");
        }
        if (this.timerState == 3 || this.timerState == 4) {
            throw new NoSuchObjectLocalException("Timer was canceled");
        }
    }

    private void assertAllowedOperation(String timerMethod) {
        AllowedOperationsAssociation.assertAllowedIn(timerMethod, AllowedOperationsAssociation.IN_BUSINESS_METHOD | AllowedOperationsAssociation.IN_EJB_TIMEOUT | AllowedOperationsAssociation.IN_SERVICE_ENDPOINT_METHOD | AllowedOperationsAssociation.IN_AFTER_BEGIN | AllowedOperationsAssociation.IN_BEFORE_COMPLETION | AllowedOperationsAssociation.IN_EJB_POST_CREATE | AllowedOperationsAssociation.IN_EJB_REMOVE | AllowedOperationsAssociation.IN_EJB_LOAD | AllowedOperationsAssociation.IN_EJB_STORE);
    }

    public void beforeCompletion() {
        switch (this.timerState) {
            case 3: {
                this.timerService.removeTimer(this);
                break;
            }
            case 6: 
            case 7: {
                if (this.periode != 0L) break;
                this.timerService.removeTimer(this);
            }
        }
    }

    public void afterCompletion(int status) {
        if (status == 3) {
            log.debug("commit: " + this);
            switch (this.timerState) {
                case 1: {
                    this.scheduleTimeout();
                    this.setTimerState(2);
                    break;
                }
                case 3: {
                    this.cancelTimer();
                    break;
                }
                case 6: 
                case 7: {
                    if (this.periode == 0L) {
                        this.setTimerState(5);
                        this.cancelTimer();
                        break;
                    }
                    this.setTimerState(2);
                }
            }
        } else if (status == 4) {
            log.debug("rollback: " + this);
            switch (this.timerState) {
                case 1: {
                    this.cancelTimer();
                    break;
                }
                case 3: {
                    this.setTimerState(2);
                    break;
                }
                case 6: {
                    this.setTimerState(7);
                    log.debug("retry: " + this);
                    this.timerService.retryTimeout(this);
                    break;
                }
                case 7: {
                    if (this.periode == 0L) {
                        this.setTimerState(5);
                        this.cancelTimer();
                        break;
                    }
                    this.setTimerState(2);
                }
            }
        }
    }

    private class TimerTaskImpl
    extends TimerTask {
        private TimerImpl timer;

        public TimerTaskImpl(TimerImpl timer) {
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.debug("run: " + this.timer);
            if (TimerImpl.this.isActive() && TimerImpl.this.periode > 0L) {
                TimerImpl.this.nextExpire += TimerImpl.this.periode;
            }
            if (TimerImpl.this.isInRetry()) {
                log.debug("Timer in retry mode, skipping this scheduled execution");
                return;
            }
            if (TimerImpl.this.isActive()) {
                try {
                    TimerImpl.this.setTimerState(6);
                    TimerImpl.this.timedObjectInvoker.callTimeout(this.timer);
                }
                catch (Exception e) {
                    log.error("Error invoking ejbTimeout: " + e.toString());
                }
                finally {
                    if (TimerImpl.this.timerState == 6) {
                        log.debug("Timer was not registered with Tx, resetting state: " + this.timer);
                        if (TimerImpl.this.periode == 0L) {
                            TimerImpl.this.setTimerState(5);
                            TimerImpl.this.killTimer();
                        } else {
                            TimerImpl.this.setTimerState(2);
                        }
                    }
                }
            }
        }
    }
}

