/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.lock;

import javax.transaction.Transaction;
import org.jboss.util.deadlock.ApplicationDeadlockException;
import org.jboss.util.deadlock.DeadlockDetector;
import org.jboss.util.deadlock.Resource;

public class NonReentrantLock
implements Resource {
    protected Thread lockHolder;
    protected Object lock = new Object();
    protected volatile int held = 0;
    protected Transaction holdingTx = null;
    private boolean inNonReentrant;

    public Object getResourceHolder() {
        if (this.holdingTx != null) {
            return this.holdingTx;
        }
        return this.lockHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean acquireNonReentrant(long waitTime, Transaction miTx) throws ApplicationDeadlockException, InterruptedException, ReentranceException {
        Object object = this.lock;
        synchronized (object) {
            Thread curThread = Thread.currentThread();
            if (this.lockHolder != null) {
                if (this.lockHolder == curThread) {
                    if (this.inNonReentrant) {
                        throw new ReentranceException("The same thread reentered: thread-holder=" + this.lockHolder + ", holding tx=" + this.holdingTx + ", current tx=" + miTx);
                    }
                } else if (miTx != null && miTx.equals(this.holdingTx)) {
                    if (this.inNonReentrant) {
                        throw new ReentranceException("The same tx reentered: tx=" + miTx + ", holding thread=" + this.lockHolder + ", current thread=" + curThread);
                    }
                } else {
                    Object deadlocker = curThread;
                    if (miTx != null) {
                        deadlocker = miTx;
                    }
                    try {
                        DeadlockDetector.singleton.deadlockDetection(deadlocker, this);
                        while (this.lockHolder != null) {
                            if (waitTime < 1L) {
                                this.lock.wait();
                            } else {
                                this.lock.wait(waitTime);
                            }
                            if (waitTime <= 0L || this.lockHolder == null) continue;
                            boolean bl = false;
                            return bl;
                        }
                    }
                    finally {
                        DeadlockDetector.singleton.removeWaiting(deadlocker);
                    }
                }
            }
            ++this.held;
            this.lockHolder = curThread;
            this.holdingTx = miTx;
            this.inNonReentrant = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean acquireReentrant(long waitTime, Transaction miTx) throws ApplicationDeadlockException, InterruptedException, ReentranceException {
        Object object = this.lock;
        synchronized (object) {
            Thread curThread = Thread.currentThread();
            if (this.lockHolder != null && this.lockHolder != curThread && (miTx == null || miTx.equals(this.holdingTx))) {
                Object deadlocker = curThread;
                if (miTx != null) {
                    deadlocker = miTx;
                }
                try {
                    DeadlockDetector.singleton.deadlockDetection(deadlocker, this);
                    while (this.lockHolder != null) {
                        if (waitTime < 1L) {
                            this.lock.wait();
                        } else {
                            this.lock.wait(waitTime);
                        }
                        if (waitTime <= 0L || this.lockHolder == null) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    DeadlockDetector.singleton.removeWaiting(deadlocker);
                }
            }
            ++this.held;
            this.lockHolder = curThread;
            this.holdingTx = miTx;
            return true;
        }
    }

    public boolean attempt(long waitTime, Transaction miTx, boolean nonReentrant) throws ApplicationDeadlockException, InterruptedException, ReentranceException {
        return nonReentrant ? this.acquireNonReentrant(waitTime, miTx) : this.acquireReentrant(waitTime, miTx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean nonReentrant) {
        Object object = this.lock;
        synchronized (object) {
            --this.held;
            if (this.held < 0) {
                throw new IllegalStateException("Released lock too many times");
            }
            if (this.held == 0) {
                this.lockHolder = null;
                this.holdingTx = null;
                this.lock.notify();
            }
            if (nonReentrant) {
                this.inNonReentrant = false;
            }
        }
    }

    public static class ReentranceException
    extends Exception {
        public ReentranceException() {
        }

        public ReentranceException(String message) {
            super(message);
        }
    }
}

