/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2.bridge;

import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityCache;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.LocalProxyFactory;
import org.jboss.ejb.plugins.cmp.bridge.EntityBridge;
import org.jboss.ejb.plugins.cmp.bridge.FieldBridge;
import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRInvocation;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRMessage;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.ejb.plugins.cmp.jdbc2.PersistentContext;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Cache;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.EntityTable;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.RelationTable;
import org.jboss.ejb.plugins.lock.Entrancy;
import org.jboss.invocation.InvocationType;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.plugins.SecurityContextAssociation;

public class JDBCCMRFieldBridge2
extends JDBCAbstractCMRFieldBridge {
    private final JDBCRelationshipRoleMetaData metadata;
    private final JDBCStoreManager2 manager;
    private final JDBCEntityBridge2 entity;
    private final int cmrIndex;
    private final Logger log;
    private JDBCEntityBridge2 relatedEntity;
    private JDBCCMRFieldBridge2 relatedCMRField;
    private EntityContainer relatedContainer;
    private JDBCCMPFieldBridge2[] tableKeyFields;
    private JDBCCMPFieldBridge2[] foreignKeyFields;
    private JDBCCMPFieldBridge2[] relatedPKFields;
    private CMRFieldLoader loader;
    private RelationTable relationTable;
    private EntityTable.ForeignKeyConstraint fkConstraint;
    private final TransactionManager tm;

    public JDBCCMRFieldBridge2(JDBCEntityBridge2 entityBridge, JDBCStoreManager2 manager, JDBCRelationshipRoleMetaData metadata) {
        this.manager = manager;
        this.entity = entityBridge;
        this.metadata = metadata;
        this.cmrIndex = this.entity.getNextCMRIndex();
        this.tm = manager.getContainer().getTransactionManager();
        this.log = Logger.getLogger(this.getClass().getName() + "." + this.entity.getEntityName() + "#" + this.getFieldName());
    }

    public void resolveRelationship() throws DeploymentException {
        String relatedEntityName = this.metadata.getRelatedRole().getEntity().getName();
        Catalog catalog = (Catalog)this.manager.getApplicationData("CATALOG");
        this.relatedEntity = (JDBCEntityBridge2)catalog.getEntityByEJBName(relatedEntityName);
        if (this.relatedEntity == null) {
            throw new DeploymentException("Related entity not found: entity=" + this.entity.getEntityName() + ", " + "cmrField=" + this.getFieldName() + ", " + "relatedEntity=" + relatedEntityName);
        }
        JDBCCMRFieldBridge2[] cmrFields = (JDBCCMRFieldBridge2[])this.relatedEntity.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            JDBCCMRFieldBridge2 cmrField = cmrFields[i];
            if (this.metadata.getRelatedRole() != cmrField.getMetaData()) continue;
            this.relatedCMRField = cmrField;
            break;
        }
        if (this.relatedCMRField == null) {
            String message = "Related CMR field not found in " + this.relatedEntity.getEntityName() + " for relationship from ";
            message = message + this.entity.getEntityName() + ".";
            message = this.getFieldName() != null ? message + this.getFieldName() : message + "<no-field>";
            message = message + " to ";
            message = message + relatedEntityName + ".";
            message = this.metadata.getRelatedRole().getCMRFieldName() != null ? message + this.metadata.getRelatedRole().getCMRFieldName() : message + "<no-field>";
            throw new DeploymentException(message);
        }
        this.relatedContainer = this.relatedEntity.getContainer();
        if (this.metadata.getRelationMetaData().isTableMappingStyle()) {
            Collection tableKeys = this.metadata.getKeyFields();
            ArrayList keyFieldsList = new ArrayList(tableKeys.size());
            HashMap<FieldBridge, JDBCCMPFieldBridge2> pkFieldsToFKFields = new HashMap<FieldBridge, JDBCCMPFieldBridge2>(tableKeys.size());
            for (JDBCCMPFieldMetaData cmpFieldMetaData : tableKeys) {
                FieldBridge pkField = this.entity.getFieldByName(cmpFieldMetaData.getFieldName());
                if (pkField == null) {
                    throw new DeploymentException("Primary key not found for key-field " + cmpFieldMetaData.getFieldName());
                }
                pkFieldsToFKFields.put(pkField, new JDBCCMPFieldBridge2(this.manager, this.entity, cmpFieldMetaData, -1));
            }
            JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
            for (int i = 0; i < pkFields.length; ++i) {
                Object fkField = pkFieldsToFKFields.get(pkFields[i]);
                if (fkField == null) {
                    throw new DeploymentException("Primary key " + pkFields[i].getFieldName() + " is not mapped.");
                }
                keyFieldsList.add(fkField);
            }
            this.tableKeyFields = keyFieldsList.toArray(new JDBCCMPFieldBridge2[keyFieldsList.size()]);
        } else {
            this.initializeForeignKeyFields();
        }
    }

    public void initLoader() throws DeploymentException {
        if (this.metadata.getRelationMetaData().isTableMappingStyle()) {
            this.relationTable = this.relatedCMRField.getRelationTable();
            this.loader = new RelationTableLoader();
        } else {
            this.loader = this.foreignKeyFields != null ? new ContextForeignKeyLoader() : new ForeignKeyLoader();
        }
    }

    public JDBCRelationshipRoleMetaData getMetaData() {
        return this.metadata;
    }

    public boolean removeRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
        FieldState state = this.getFieldState(ctx);
        return state.removeRelatedId(ctx, relatedId);
    }

    public boolean addRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
        FieldState state = this.getFieldState(ctx);
        return state.addRelatedId(ctx, relatedId);
    }

    public void remove(EntityEnterpriseContext ctx) throws RemoveException {
        if (this.metadata.getRelatedRole().isCascadeDelete()) {
            FieldState state = this.getFieldState(ctx);
            state.cascadeDelete(ctx);
        } else {
            this.destroyExistingRelationships(ctx);
        }
    }

    public void destroyExistingRelationships(EntityEnterpriseContext ctx) {
        FieldState state = this.getFieldState(ctx);
        state.destroyExistingRelationships(ctx);
    }

    public JDBCFieldBridge[] getTableKeyFields() {
        return this.tableKeyFields;
    }

    public JDBCEntityPersistenceStore getManager() {
        return this.manager;
    }

    public boolean hasForeignKey() {
        return this.foreignKeyFields != null;
    }

    public JDBCAbstractCMRFieldBridge getRelatedCMRField() {
        return this.relatedCMRField;
    }

    public JDBCFieldBridge[] getForeignKeyFields() {
        return this.foreignKeyFields;
    }

    public JDBCCMRFieldBridge2 getRelatedField() {
        return this.relatedCMRField;
    }

    public JDBCAbstractEntityBridge getEntity() {
        return this.entity;
    }

    public String getQualifiedTableName() {
        return this.relationTable.getTableName();
    }

    public String getTableName() {
        throw new UnsupportedOperationException();
    }

    public JDBCType getJDBCType() {
        throw new UnsupportedOperationException();
    }

    public boolean isPrimaryKeyMember() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadTimedOut(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public boolean isLoaded(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public void initInstance(EntityEnterpriseContext ctx) {
        this.getFieldState(ctx).init();
    }

    public void resetPersistenceContext(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public int setInstanceParameters(PreparedStatement ps, int parameterIndex, EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public Object getInstanceValue(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public void setInstanceValue(EntityEnterpriseContext ctx, Object value) {
        throw new UnsupportedOperationException();
    }

    public int loadInstanceResults(ResultSet rs, int parameterIndex, EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] argumentRef) {
        throw new UnsupportedOperationException();
    }

    public boolean isDirty(EntityEnterpriseContext ctx) {
        return this.getFieldState(ctx).isModified();
    }

    public void setClean(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public boolean isCMPField() {
        return false;
    }

    public String getFieldName() {
        return this.metadata.getCMRFieldName();
    }

    public Object getValue(EntityEnterpriseContext ctx) {
        FieldState state = this.getFieldState(ctx);
        return state.getValue(ctx);
    }

    public void setValue(EntityEnterpriseContext ctx, Object value) {
        FieldState state = this.getFieldState(ctx);
        state.setValue(ctx, value);
        state.cacheValue(ctx);
    }

    public boolean isSingleValued() {
        return this.metadata.getRelatedRole().isMultiplicityOne();
    }

    public EntityBridge getRelatedEntity() {
        return this.relatedEntity;
    }

    private void initializeForeignKeyFields() throws DeploymentException {
        Collection foreignKeys = this.metadata.getRelatedRole().getKeyFields();
        HashMap<JDBCCMPFieldBridge2, JDBCCMPFieldBridge2> fkFieldsByRelatedPKFields = new HashMap<JDBCCMPFieldBridge2, JDBCCMPFieldBridge2>();
        for (JDBCCMPFieldMetaData fkFieldMetaData : foreignKeys) {
            JDBCCMPFieldBridge2 relatedPKField = (JDBCCMPFieldBridge2)this.relatedEntity.getFieldByName(fkFieldMetaData.getFieldName());
            String fkColumnName = fkFieldMetaData.getColumnName();
            JDBCCMPFieldBridge2 fkField = null;
            JDBCCMPFieldBridge2[] tableFields = (JDBCCMPFieldBridge2[])this.entity.getTableFields();
            for (int tableInd = 0; tableInd < tableFields.length && fkField == null; ++tableInd) {
                JDBCCMPFieldBridge2 cmpField = tableFields[tableInd];
                if (!fkColumnName.equals(cmpField.getColumnName())) continue;
                fkField = new JDBCCMPFieldBridge2(cmpField, relatedPKField);
            }
            if (fkField == null) {
                fkField = this.entity.addTableField(fkFieldMetaData);
            }
            fkFieldsByRelatedPKFields.put(relatedPKField, fkField);
        }
        if (fkFieldsByRelatedPKFields.size() > 0) {
            JDBCFieldBridge[] pkFields = this.relatedEntity.getPrimaryKeyFields();
            ArrayList<JDBCCMPFieldBridge2> fkList = new ArrayList<JDBCCMPFieldBridge2>(pkFields.length);
            ArrayList<JDBCFieldBridge> relatedPKList = new ArrayList<JDBCFieldBridge>(pkFields.length);
            for (int i = 0; i < pkFields.length; ++i) {
                JDBCFieldBridge relatedPKField = pkFields[i];
                JDBCCMPFieldBridge2 fkField = (JDBCCMPFieldBridge2)fkFieldsByRelatedPKFields.remove(relatedPKField);
                fkList.add(fkField);
                relatedPKList.add(relatedPKField);
            }
            this.foreignKeyFields = fkList.toArray(new JDBCCMPFieldBridge2[fkList.size()]);
            this.relatedPKFields = relatedPKList.toArray(new JDBCCMPFieldBridge2[relatedPKList.size()]);
            if (this.metadata.hasForeignKeyConstraint()) {
                this.fkConstraint = this.entity.getTable().addFkConstraint(this.foreignKeyFields, this.relatedEntity.getTable());
            }
        } else {
            this.foreignKeyFields = null;
            this.relatedPKFields = null;
        }
    }

    private FieldState getFieldState(EntityEnterpriseContext ctx) {
        PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
        FieldState state = pctx.getCMRState(this.cmrIndex);
        if (state == null) {
            state = this.isSingleValued() ? new SingleValuedFieldState() : new CollectionValuedFieldState();
            pctx.setCMRState(this.cmrIndex, state);
        }
        return state;
    }

    private void invokeRemoveRelatedId(Object myId, Object relatedId) {
        try {
            Transaction tx = this.getTransaction();
            EntityCache instanceCache = (EntityCache)this.manager.getContainer().getInstanceCache();
            SecurityActions actions = SecurityActions.UTIL.getSecurityActions();
            CMRInvocation invocation = new CMRInvocation();
            invocation.setCmrMessage(CMRMessage.REMOVE_RELATION);
            invocation.setEntrancy(Entrancy.NON_ENTRANT);
            invocation.setId(instanceCache.createCacheKey(myId));
            invocation.setArguments(new Object[]{this, relatedId});
            invocation.setTransaction(tx);
            invocation.setPrincipal(actions.getPrincipal());
            invocation.setCredential(actions.getCredential());
            invocation.setType(InvocationType.LOCAL);
            this.manager.getContainer().invoke(invocation);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error in invokeRemoveRelatedId()", e);
        }
    }

    private void invokeAddRelatedId(Object myId, Object relatedId) {
        try {
            Transaction tx = this.getTransaction();
            EntityCache instanceCache = (EntityCache)this.manager.getContainer().getInstanceCache();
            SecurityActions actions = SecurityActions.UTIL.getSecurityActions();
            CMRInvocation invocation = new CMRInvocation();
            invocation.setCmrMessage(CMRMessage.ADD_RELATION);
            invocation.setEntrancy(Entrancy.NON_ENTRANT);
            invocation.setId(instanceCache.createCacheKey(myId));
            invocation.setArguments(new Object[]{this, relatedId});
            invocation.setTransaction(tx);
            invocation.setPrincipal(actions.getPrincipal());
            invocation.setCredential(actions.getCredential());
            invocation.setType(InvocationType.LOCAL);
            this.manager.getContainer().invoke(invocation);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error in invokeAddRelatedId()", e);
        }
    }

    private Transaction getTransaction() throws SystemException {
        return this.tm.getTransaction();
    }

    private RelationTable getRelationTable() throws DeploymentException {
        if (this.relationTable == null) {
            this.relationTable = this.manager.getSchema().createRelationTable(this, this.relatedCMRField);
        }
        return this.relationTable;
    }

    private Object getPrimaryKey(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("This implementation does not support null members.");
        }
        if (!this.relatedEntity.getLocalInterface().isInstance(o)) {
            throw new IllegalArgumentException("Argument must be of type " + this.entity.getLocalInterface().getName());
        }
        EJBLocalObject local = (EJBLocalObject)o;
        try {
            return local.getPrimaryKey();
        }
        catch (NoSuchObjectLocalException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    static interface SecurityActions {
        public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

            public Principal getPrincipal() {
                Principal p = null;
                SecurityContext sc = this.getSecurityContext();
                if (sc != null) {
                    p = sc.getUtil().getUserPrincipal();
                }
                return p;
            }

            public Object getCredential() {
                Object credential = null;
                SecurityContext sc = this.getSecurityContext();
                if (sc != null) {
                    credential = sc.getUtil().getCredential();
                }
                return credential;
            }

            public SecurityContext getSecurityContext() {
                return SecurityContextAssociation.getSecurityContext();
            }
        };
        public static final SecurityActions PRIVILEGED = new SecurityActions(){
            private final PrivilegedAction getPrincipalAction = new PrivilegedAction(){

                public Object run() {
                    Principal p = null;
                    SecurityContext sc = this.getSecurityContext();
                    if (sc != null) {
                        p = sc.getUtil().getUserPrincipal();
                    }
                    return p;
                }
            };
            private final PrivilegedAction getCredentialAction = new PrivilegedAction(){

                public Object run() {
                    Object credential = null;
                    SecurityContext sc = this.getSecurityContext();
                    if (sc != null) {
                        credential = sc.getUtil().getCredential();
                    }
                    return credential;
                }
            };

            public Principal getPrincipal() {
                return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
            }

            public Object getCredential() {
                return AccessController.doPrivileged(this.getCredentialAction);
            }

            public SecurityContext getSecurityContext() {
                return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return SecurityContextAssociation.getSecurityContext();
                    }
                });
            }
        };

        public Principal getPrincipal();

        public Object getCredential();

        public SecurityContext getSecurityContext();

        public static class UTIL {
            static SecurityActions getSecurityActions() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }
        }
    }

    private class CMRSet
    implements Set {
        private final EntityEnterpriseContext ctx;
        private final CollectionValuedFieldState state;

        public CMRSet(EntityEnterpriseContext ctx, CollectionValuedFieldState state) {
            this.ctx = ctx;
            this.state = state;
        }

        public int size() {
            return this.state.getLoadedValue(this.ctx).size();
        }

        public void clear() {
            JDBCCMRFieldBridge2.this.destroyExistingRelationships(this.ctx);
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public boolean add(Object o) {
            Object relatedId = JDBCCMRFieldBridge2.this.getPrimaryKey(o);
            boolean modified = JDBCCMRFieldBridge2.this.addRelatedId(this.ctx, relatedId);
            if (modified) {
                JDBCCMRFieldBridge2.this.relatedCMRField.invokeAddRelatedId(relatedId, this.ctx.getId());
                JDBCCMRFieldBridge2.this.loader.addRelatedId(this.ctx, relatedId);
            }
            return modified;
        }

        public boolean contains(Object o) {
            Object pk = JDBCCMRFieldBridge2.this.getPrimaryKey(o);
            return this.state.getLoadedValue(this.ctx).contains(pk);
        }

        public boolean remove(Object o) {
            Object relatedId = JDBCCMRFieldBridge2.this.getPrimaryKey(o);
            return this.removeById(relatedId);
        }

        public boolean addAll(Collection c) {
            if (c == null || c.isEmpty()) {
                return false;
            }
            boolean modified = false;
            Object[] copy = c.toArray();
            for (int i = 0; i < copy.length; ++i) {
                modified = this.add(copy[i]) || modified;
            }
            return modified;
        }

        public boolean containsAll(Collection c) {
            if (c == null || c.isEmpty()) {
                return true;
            }
            Set ids = this.argumentToIdSet(c);
            return this.state.getLoadedValue(this.ctx).containsAll(ids);
        }

        public boolean removeAll(Collection c) {
            if (c == null || c.isEmpty()) {
                return false;
            }
            boolean modified = false;
            Object[] copy = c.toArray();
            for (int i = 0; i < copy.length; ++i) {
                modified = this.remove(copy[i]) || modified;
            }
            return modified;
        }

        public boolean retainAll(Collection c) {
            Set value = this.state.getLoadedValue(this.ctx);
            if (c == null || c.isEmpty()) {
                if (value.isEmpty()) {
                    return false;
                }
                this.clear();
            }
            boolean modified = false;
            Set idSet = this.argumentToIdSet(c);
            Object[] valueCopy = value.toArray();
            for (int i = 0; i < valueCopy.length; ++i) {
                Object id = valueCopy[i];
                if (idSet.contains(id)) continue;
                this.removeById(id);
                modified = true;
            }
            return modified;
        }

        public Iterator iterator() {
            return new Iterator(){
                private final Iterator idIter;
                private Object curId;
                {
                    this.idIter = new HashSet(CMRSet.this.state.getLoadedValue(CMRSet.this.ctx)).iterator();
                }

                public void remove() {
                    try {
                        this.idIter.remove();
                    }
                    catch (ConcurrentModificationException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    CMRSet.this.removeById(this.curId);
                }

                public boolean hasNext() {
                    try {
                        return this.idIter.hasNext();
                    }
                    catch (ConcurrentModificationException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                }

                public Object next() {
                    try {
                        this.curId = this.idIter.next();
                    }
                    catch (ConcurrentModificationException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    return JDBCCMRFieldBridge2.this.relatedContainer.getLocalProxyFactory().getEntityEJBLocalObject(this.curId);
                }
            };
        }

        public Object[] toArray() {
            Set value = this.state.getLoadedValue(this.ctx);
            Object[] result = (Object[])Array.newInstance(JDBCCMRFieldBridge2.this.relatedEntity.getLocalInterface(), value.size());
            LocalProxyFactory relatedPF = JDBCCMRFieldBridge2.this.relatedContainer.getLocalProxyFactory();
            int i = 0;
            for (Object id : value) {
                result[i++] = relatedPF.getEntityEJBLocalObject(id);
            }
            return result;
        }

        public Object[] toArray(Object[] a) {
            Set value = this.state.getLoadedValue(this.ctx);
            if (a == null || a.length < value.size()) {
                a = (Object[])Array.newInstance(JDBCCMRFieldBridge2.this.entity.getLocalInterface(), value.size());
            }
            LocalProxyFactory relatedPF = JDBCCMRFieldBridge2.this.relatedContainer.getLocalProxyFactory();
            int i = 0;
            for (Object id : value) {
                a[i++] = relatedPF.getEntityEJBLocalObject(id);
            }
            return a;
        }

        public String toString() {
            return this.state.getLoadedValue(this.ctx).toString();
        }

        private boolean removeById(Object relatedId) {
            boolean modified = JDBCCMRFieldBridge2.this.removeRelatedId(this.ctx, relatedId);
            if (modified) {
                JDBCCMRFieldBridge2.this.relatedCMRField.invokeRemoveRelatedId(relatedId, this.ctx.getId());
                JDBCCMRFieldBridge2.this.loader.removeRelatedId(this.ctx, relatedId);
            }
            return modified;
        }

        private Set argumentToIdSet(Collection c) {
            HashSet<Object> ids = new HashSet<Object>();
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                Object pk = JDBCCMRFieldBridge2.this.getPrimaryKey(iter.next());
                ids.add(pk);
            }
            return ids;
        }
    }

    private static interface CMRFieldLoader {
        public void load(EntityEnterpriseContext var1, FieldState var2);

        public void removeRelatedId(EntityEnterpriseContext var1, Object var2);

        public void addRelatedId(EntityEnterpriseContext var1, Object var2);
    }

    private class ContextForeignKeyLoader
    implements CMRFieldLoader {
        private ContextForeignKeyLoader() {
        }

        public void load(EntityEnterpriseContext ctx, FieldState state) {
            JDBCCMPFieldBridge2 fkField;
            Object fkFieldValue;
            Object relatedId = null;
            for (int i = 0; i < JDBCCMRFieldBridge2.this.foreignKeyFields.length && (fkFieldValue = (fkField = JDBCCMRFieldBridge2.this.foreignKeyFields[i]).getValue(ctx)) != null; ++i) {
                JDBCCMPFieldBridge2 relatedPKField = JDBCCMRFieldBridge2.this.relatedPKFields[i];
                relatedId = relatedPKField.setPrimaryKeyValue(relatedId, fkFieldValue);
            }
            state.addLoadedPk(relatedId);
        }

        public void removeRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
            for (int i = 0; i < JDBCCMRFieldBridge2.this.foreignKeyFields.length; ++i) {
                JDBCCMRFieldBridge2.this.foreignKeyFields[i].setValueInternal(ctx, null, JDBCCMRFieldBridge2.this.fkConstraint == null);
            }
            if (JDBCCMRFieldBridge2.this.fkConstraint != null) {
                PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
                pctx.nullForeignKey(JDBCCMRFieldBridge2.this.fkConstraint);
            }
        }

        public void addRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
            boolean markDirty = relatedId != null || JDBCCMRFieldBridge2.this.fkConstraint == null;
            for (int i = 0; i < JDBCCMRFieldBridge2.this.foreignKeyFields.length; ++i) {
                JDBCCMPFieldBridge2 relatedPKField = JDBCCMRFieldBridge2.this.relatedPKFields[i];
                Object fieldValue = relatedPKField.getPrimaryKeyValue(relatedId);
                JDBCCMRFieldBridge2.this.foreignKeyFields[i].setValueInternal(ctx, fieldValue, markDirty);
            }
            if (JDBCCMRFieldBridge2.this.fkConstraint != null) {
                PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
                if (relatedId == null) {
                    pctx.nullForeignKey(JDBCCMRFieldBridge2.this.fkConstraint);
                } else {
                    pctx.nonNullForeignKey(JDBCCMRFieldBridge2.this.fkConstraint);
                }
            }
        }
    }

    private class ForeignKeyLoader
    implements CMRFieldLoader {
        private final String loadSql;

        public ForeignKeyLoader() {
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            JDBCCMRFieldBridge2.this.relatedEntity.getTable().appendColumnNames((JDBCCMPFieldBridge2[])JDBCCMRFieldBridge2.this.relatedEntity.getTableFields(), null, sql);
            sql.append(" from ").append(JDBCCMRFieldBridge2.this.relatedEntity.getQualifiedTableName()).append(" where ");
            JDBCCMPFieldBridge2[] relatedFkFields = JDBCCMRFieldBridge2.this.relatedCMRField.foreignKeyFields;
            sql.append(relatedFkFields[0].getColumnName()).append("=?");
            for (int i = 1; i < relatedFkFields.length; ++i) {
                JDBCCMPFieldBridge2 relatedFkField = relatedFkFields[i];
                sql.append(" and ").append(relatedFkField.getColumnName()).append("=?");
            }
            this.loadSql = sql.toString();
            if (JDBCCMRFieldBridge2.this.log.isTraceEnabled()) {
                JDBCCMRFieldBridge2.this.log.trace("load sql: " + this.loadSql);
            }
        }

        public void load(EntityEnterpriseContext ctx, FieldState state) {
            EntityTable relatedTable = JDBCCMRFieldBridge2.this.relatedEntity.getTable();
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                if (JDBCCMRFieldBridge2.this.log.isDebugEnabled()) {
                    JDBCCMRFieldBridge2.this.log.debug("executing: " + this.loadSql);
                }
                con = relatedTable.getDataSource().getConnection();
                ps = con.prepareStatement(this.loadSql);
                JDBCCMPFieldBridge2[] relatedFkFields = JDBCCMRFieldBridge2.this.relatedCMRField.foreignKeyFields;
                JDBCCMPFieldBridge2[] myPkFields = JDBCCMRFieldBridge2.this.relatedCMRField.relatedPKFields;
                Object myPk = ctx.getId();
                int paramInd = 1;
                for (int i = 0; i < relatedFkFields.length; ++i) {
                    JDBCCMPFieldBridge2 myPkField = myPkFields[i];
                    Object fieldValue = myPkField.getPrimaryKeyValue(myPk);
                    JDBCCMPFieldBridge2 relatedFkField = relatedFkFields[i];
                    relatedFkField.setArgumentParameters(ps, paramInd++, fieldValue);
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    Object value = relatedTable.loadRow(rs, false);
                    state.addLoadedPk(value);
                }
            }
            catch (SQLException e) {
                try {
                    JDBCCMRFieldBridge2.this.log.error("Failed to load related role: ejb-name=" + JDBCCMRFieldBridge2.this.entity.getEntityName() + ", cmr-field=" + JDBCCMRFieldBridge2.this.getFieldName() + ": " + e.getMessage(), e);
                    throw new EJBException("Failed to load related role: ejb-name=" + JDBCCMRFieldBridge2.this.entity.getEntityName() + ", cmr-field=" + JDBCCMRFieldBridge2.this.getFieldName() + ": " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    JDBCUtil.safeClose(rs);
                    JDBCUtil.safeClose(ps);
                    JDBCUtil.safeClose(con);
                    throw throwable;
                }
            }
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
        }

        public void removeRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
        }

        public void addRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
        }
    }

    private class RelationTableLoader
    implements CMRFieldLoader {
        private final String loadSql;

        public RelationTableLoader() {
            int i;
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            String relatedTable = JDBCCMRFieldBridge2.this.relatedEntity.getQualifiedTableName();
            String relationTable = JDBCCMRFieldBridge2.this.metadata.getRelationMetaData().getDefaultTableName();
            JDBCCMRFieldBridge2.this.relatedEntity.getTable().appendColumnNames((JDBCCMPFieldBridge2[])JDBCCMRFieldBridge2.this.relatedEntity.getTableFields(), relatedTable, sql);
            sql.append(" from ").append(relatedTable).append(" inner join ").append(relationTable).append(" on ");
            JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])JDBCCMRFieldBridge2.this.relatedEntity.getPrimaryKeyFields();
            for (i = 0; i < pkFields.length; ++i) {
                if (i > 0) {
                    sql.append(" and ");
                }
                sql.append(relatedTable).append('.').append(pkFields[i].getColumnName()).append('=').append(relationTable).append('.').append(JDBCCMRFieldBridge2.this.relatedCMRField.tableKeyFields[i].getColumnName());
            }
            sql.append(" where ");
            for (i = 0; i < JDBCCMRFieldBridge2.this.tableKeyFields.length; ++i) {
                if (i > 0) {
                    sql.append(" and ");
                }
                sql.append(relationTable).append('.').append(JDBCCMRFieldBridge2.this.tableKeyFields[i].getColumnName()).append("=?");
            }
            this.loadSql = sql.toString();
            if (JDBCCMRFieldBridge2.this.log.isTraceEnabled()) {
                JDBCCMRFieldBridge2.this.log.trace("load sql: " + this.loadSql);
            }
        }

        public void load(EntityEnterpriseContext ctx, FieldState state) {
            EntityTable relatedTable = JDBCCMRFieldBridge2.this.relatedEntity.getTable();
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                if (JDBCCMRFieldBridge2.this.log.isDebugEnabled()) {
                    JDBCCMRFieldBridge2.this.log.debug("executing: " + this.loadSql);
                }
                con = relatedTable.getDataSource().getConnection();
                ps = con.prepareStatement(this.loadSql);
                JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])JDBCCMRFieldBridge2.this.entity.getPrimaryKeyFields();
                Object myPk = ctx.getId();
                int paramInd = 1;
                for (int i = 0; i < pkFields.length; ++i) {
                    JDBCCMPFieldBridge2 pkField = pkFields[i];
                    Object fieldValue = pkField.getPrimaryKeyValue(myPk);
                    JDBCCMPFieldBridge2 relatedFkField = JDBCCMRFieldBridge2.this.tableKeyFields[i];
                    relatedFkField.setArgumentParameters(ps, paramInd++, fieldValue);
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    Object value = relatedTable.loadRow(rs, false);
                    state.addLoadedPk(value);
                }
            }
            catch (SQLException e) {
                try {
                    JDBCCMRFieldBridge2.this.log.error("Failed to load related role: ejb-name=" + JDBCCMRFieldBridge2.this.entity.getEntityName() + ", cmr-field=" + JDBCCMRFieldBridge2.this.getFieldName() + ": " + e.getMessage(), e);
                    throw new EJBException("Failed to load related role: ejb-name=" + JDBCCMRFieldBridge2.this.entity.getEntityName() + ", cmr-field=" + JDBCCMRFieldBridge2.this.getFieldName() + ": " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    JDBCUtil.safeClose(rs);
                    JDBCUtil.safeClose(ps);
                    JDBCUtil.safeClose(con);
                    throw throwable;
                }
            }
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
        }

        public void removeRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
            JDBCCMRFieldBridge2.this.relationTable.removeRelation(JDBCCMRFieldBridge2.this, ctx.getId(), JDBCCMRFieldBridge2.this.relatedCMRField, relatedId);
        }

        public void addRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
            JDBCCMRFieldBridge2.this.relationTable.addRelation(JDBCCMRFieldBridge2.this, ctx.getId(), JDBCCMRFieldBridge2.this.relatedCMRField, relatedId);
        }
    }

    public static interface FieldState
    extends Cache.CacheLoader {
        public static final Object NULL_VALUE = new Object();

        public void init();

        public Object getValue(EntityEnterpriseContext var1);

        public void cascadeDelete(EntityEnterpriseContext var1) throws RemoveException;

        public void destroyExistingRelationships(EntityEnterpriseContext var1);

        public void setValue(EntityEnterpriseContext var1, Object var2);

        public boolean removeRelatedId(EntityEnterpriseContext var1, Object var2);

        public boolean addRelatedId(EntityEnterpriseContext var1, Object var2);

        public void addLoadedPk(Object var1);

        public void cacheValue(EntityEnterpriseContext var1);

        public boolean isModified();
    }

    public class CollectionValuedFieldState
    implements FieldState {
        private boolean loaded;
        private Set value;
        private CMRSet cmrSet;
        private Set removedWhileNotLoaded;
        private Set addedWhileNotLoaded;
        private boolean modified;

        public void init() {
            this.loaded = true;
            this.value = new HashSet();
        }

        public Object getValue(EntityEnterpriseContext ctx) {
            if (this.cmrSet == null) {
                this.cmrSet = new CMRSet(ctx, this);
            }
            return this.cmrSet;
        }

        public void setValue(EntityEnterpriseContext ctx, Object value) {
            if (value == null) {
                throw new IllegalArgumentException("Can't set collection-valued CMR field to null: " + JDBCCMRFieldBridge2.this.entity.getEntityName() + "." + JDBCCMRFieldBridge2.this.getFieldName());
            }
            this.destroyExistingRelationships(ctx);
            Collection newValue = (Collection)value;
            if (!newValue.isEmpty()) {
                HashSet copy = new HashSet(newValue);
                Iterator iter = copy.iterator();
                while (iter.hasNext()) {
                    Object relatedId = JDBCCMRFieldBridge2.this.getPrimaryKey(iter.next());
                    this.addRelatedId(ctx, relatedId);
                    JDBCCMRFieldBridge2.this.relatedCMRField.invokeAddRelatedId(relatedId, ctx.getId());
                    JDBCCMRFieldBridge2.this.loader.addRelatedId(ctx, relatedId);
                }
            }
        }

        public void cascadeDelete(EntityEnterpriseContext ctx) throws RemoveException {
            Collection value = (Collection)this.getValue(ctx);
            if (!value.isEmpty()) {
                EJBLocalObject[] locals = (EJBLocalObject[])value.toArray();
                for (int i = 0; i < locals.length; ++i) {
                    locals[i].remove();
                }
            }
        }

        public void destroyExistingRelationships(EntityEnterpriseContext ctx) {
            Set value = this.getLoadedValue(ctx);
            if (!value.isEmpty()) {
                Object[] copy = value.toArray();
                for (int i = 0; i < copy.length; ++i) {
                    Object relatedId = copy[i];
                    this.removeRelatedId(ctx, relatedId);
                    JDBCCMRFieldBridge2.this.relatedCMRField.invokeRemoveRelatedId(relatedId, ctx.getId());
                    JDBCCMRFieldBridge2.this.loader.removeRelatedId(ctx, relatedId);
                }
            }
        }

        public boolean removeRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
            boolean removed = false;
            if (this.loaded) {
                Set value = this.getLoadedValue(ctx);
                if (!value.isEmpty()) {
                    removed = value.remove(relatedId);
                }
            } else {
                this.loadOnlyFromCache(ctx);
                if (this.loaded) {
                    Set value = this.getLoadedValue(ctx);
                    if (!value.isEmpty()) {
                        removed = value.remove(relatedId);
                    }
                } else {
                    removed = this.removeWhileNotLoaded(relatedId);
                }
            }
            this.modified = true;
            if (removed) {
                ((PersistentContext)ctx.getPersistenceContext()).setDirtyRelations();
            }
            return removed;
        }

        public boolean addRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
            boolean added;
            if (this.loaded) {
                Set value = this.getLoadedValue(ctx);
                added = value.add(relatedId);
            } else {
                this.loadOnlyFromCache(ctx);
                if (this.loaded) {
                    Set value = this.getLoadedValue(ctx);
                    added = value.add(relatedId);
                } else {
                    added = this.addWhileNotLoaded(relatedId);
                }
            }
            this.modified = true;
            if (added) {
                ((PersistentContext)ctx.getPersistenceContext()).setDirtyRelations();
            }
            return added;
        }

        public void addLoadedPk(Object pk) {
            if (this.loaded) {
                throw new IllegalStateException(JDBCCMRFieldBridge2.this.entity.getEntityName() + "." + JDBCCMRFieldBridge2.this.getFieldName() + " collection-valued CMR field is already loaded. Check the database for consistancy. " + " current value=" + this.value + ", loaded value=" + pk);
            }
            if (pk != null) {
                this.value.add(pk);
            }
        }

        public Object loadFromCache(Object value) {
            if (value != null) {
                value = this.value = new HashSet(value);
                this.loaded = true;
            }
            return value;
        }

        public Object getCachedValue() {
            return this.value;
        }

        public void cacheValue(EntityEnterpriseContext ctx) {
            PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
            pctx.cacheRelations(JDBCCMRFieldBridge2.this.cmrIndex, this);
        }

        public boolean isModified() {
            return this.modified;
        }

        private Set getLoadedValue(EntityEnterpriseContext ctx) {
            if (!this.loaded) {
                this.loadOnlyFromCache(ctx);
                if (!this.loaded) {
                    if (this.value == null || this.value == Collections.EMPTY_SET) {
                        this.value = new HashSet();
                    }
                    JDBCCMRFieldBridge2.this.loader.load(ctx, this);
                    this.cacheValue(ctx);
                    this.loaded = true;
                }
                if (this.addedWhileNotLoaded != null) {
                    this.value.addAll(this.addedWhileNotLoaded);
                    this.addedWhileNotLoaded = null;
                }
                if (this.removedWhileNotLoaded != null) {
                    this.value.removeAll(this.removedWhileNotLoaded);
                    this.removedWhileNotLoaded = null;
                }
            }
            return this.value;
        }

        private void loadOnlyFromCache(EntityEnterpriseContext ctx) {
            PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
            if (pctx == null) {
                throw new EJBException("Persistence context is not available! Make sure the CMR collection is accessed in the transaction it was obtained.");
            }
            pctx.loadCachedRelations(JDBCCMRFieldBridge2.this.cmrIndex, this);
        }

        private boolean removeWhileNotLoaded(Object relatedId) {
            boolean removed = false;
            if (this.addedWhileNotLoaded != null) {
                removed = this.addedWhileNotLoaded.remove(relatedId);
            }
            if (!removed) {
                if (this.removedWhileNotLoaded == null) {
                    this.removedWhileNotLoaded = new HashSet();
                }
                removed = this.removedWhileNotLoaded.add(relatedId);
            }
            if (JDBCCMRFieldBridge2.this.log.isTraceEnabled() && removed) {
                JDBCCMRFieldBridge2.this.log.trace("removed while not loaded: relatedId=" + relatedId);
            }
            return removed;
        }

        private boolean addWhileNotLoaded(Object relatedId) {
            boolean added = false;
            if (this.removedWhileNotLoaded != null) {
                added = this.removedWhileNotLoaded.remove(relatedId);
            }
            if (!added) {
                if (this.addedWhileNotLoaded == null) {
                    this.addedWhileNotLoaded = new HashSet();
                }
                added = this.addedWhileNotLoaded.add(relatedId);
            }
            if (JDBCCMRFieldBridge2.this.log.isTraceEnabled() && added) {
                JDBCCMRFieldBridge2.this.log.trace("added while not loaded: relatedId=" + relatedId);
            }
            return added;
        }
    }

    public class SingleValuedFieldState
    implements FieldState {
        private boolean loaded;
        private Object value;
        private EJBLocalObject localObject;
        private boolean modified;

        public void init() {
            this.loaded = true;
        }

        public Object getValue(EntityEnterpriseContext ctx) {
            Object value = this.getLoadedValue(ctx);
            if (value == null) {
                this.localObject = null;
            } else if (this.localObject == null) {
                this.localObject = JDBCCMRFieldBridge2.this.relatedContainer.getLocalProxyFactory().getEntityEJBLocalObject(value);
            }
            return this.localObject;
        }

        public void setValue(EntityEnterpriseContext ctx, Object value) {
            if (value != null) {
                Object relatedId = JDBCCMRFieldBridge2.this.getPrimaryKey(value);
                this.addRelatedId(ctx, relatedId);
                JDBCCMRFieldBridge2.this.relatedCMRField.invokeAddRelatedId(relatedId, ctx.getId());
                this.localObject = (EJBLocalObject)value;
            } else {
                this.destroyExistingRelationships(ctx);
            }
        }

        public void cascadeDelete(EntityEnterpriseContext ctx) throws RemoveException {
            if (JDBCCMRFieldBridge2.this.manager.registerCascadeDelete(ctx.getId(), ctx.getId())) {
                EJBLocalObject value = (EJBLocalObject)this.getValue(ctx);
                if (value != null) {
                    this.changeValue(null);
                    Object relatedId = value.getPrimaryKey();
                    JDBCStoreManager2 relatedManager = (JDBCStoreManager2)JDBCCMRFieldBridge2.this.relatedEntity.getManager();
                    if (!relatedManager.isCascadeDeleted(relatedId)) {
                        value.remove();
                    }
                }
                JDBCCMRFieldBridge2.this.manager.unregisterCascadeDelete(ctx.getId());
            }
        }

        public void destroyExistingRelationships(EntityEnterpriseContext ctx) {
            Object value = this.getLoadedValue(ctx);
            if (value != null) {
                this.removeRelatedId(ctx, value);
                JDBCCMRFieldBridge2.this.relatedCMRField.invokeRemoveRelatedId(value, ctx.getId());
            }
        }

        public boolean removeRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
            if (JDBCCMRFieldBridge2.this.hasForeignKey()) {
                this.getLoadedValue(ctx);
            }
            this.changeValue(null);
            JDBCCMRFieldBridge2.this.loader.removeRelatedId(ctx, relatedId);
            this.cacheValue(ctx);
            this.modified = true;
            return true;
        }

        public boolean addRelatedId(EntityEnterpriseContext ctx, Object relatedId) {
            Object value = this.getLoadedValue(ctx);
            if (value != null) {
                JDBCCMRFieldBridge2.this.relatedCMRField.invokeRemoveRelatedId(value, ctx.getId());
            }
            this.changeValue(relatedId);
            JDBCCMRFieldBridge2.this.loader.addRelatedId(ctx, relatedId);
            this.cacheValue(ctx);
            this.modified = true;
            return true;
        }

        public void addLoadedPk(Object pk) {
            if (this.loaded) {
                throw new IllegalStateException(JDBCCMRFieldBridge2.this.entity.getEntityName() + "." + JDBCCMRFieldBridge2.this.getFieldName() + " single-valued CMR field is already loaded. Check the database for consistancy. " + " current value=" + this.value + ", loaded value=" + pk);
            }
            this.changeValue(pk);
        }

        public Object loadFromCache(Object value) {
            if (value != null) {
                this.changeValue(NULL_VALUE == value ? null : value);
            }
            return value;
        }

        public Object getCachedValue() {
            return this.value == null ? NULL_VALUE : this.value;
        }

        public void cacheValue(EntityEnterpriseContext ctx) {
            PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
            pctx.cacheRelations(JDBCCMRFieldBridge2.this.cmrIndex, this);
        }

        public boolean isModified() {
            return this.modified;
        }

        private void changeValue(Object newValue) {
            this.value = newValue;
            this.localObject = null;
            this.loaded = true;
        }

        private Object getLoadedValue(EntityEnterpriseContext ctx) {
            if (!this.loaded) {
                PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
                pctx.loadCachedRelations(JDBCCMRFieldBridge2.this.cmrIndex, this);
                if (!this.loaded) {
                    JDBCCMRFieldBridge2.this.loader.load(ctx, this);
                    this.loaded = true;
                    this.cacheValue(ctx);
                }
            }
            return this.value;
        }
    }
}

