/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.security.GeneralSecurityException;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.TransactionRolledbackException;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.JBossLazyUnmarshallingException;
import org.jboss.metadata.BeanMetaData;
import org.jboss.tm.JBossTransactionRolledbackException;
import org.jboss.tm.JBossTransactionRolledbackLocalException;

public class LogInterceptor
extends AbstractInterceptor {
    protected String ejbName;
    protected boolean callLogging;

    public void create() throws Exception {
        super.start();
        BeanMetaData md = this.getContainer().getBeanMetaData();
        this.ejbName = md.getEjbName();
        this.callLogging = md.getContainerConfiguration().getCallLogging();
    }

    public Object invokeHome(Invocation invocation) throws Exception {
        Object str;
        String methodName = invocation.getMethod() != null ? invocation.getMethod().getName() : "<no method>";
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("Start method=" + methodName);
        }
        if (this.callLogging) {
            str = new StringBuffer("InvokeHome: ");
            ((StringBuffer)str).append(methodName);
            ((StringBuffer)str).append("(");
            Object[] args = invocation.getArguments();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        ((StringBuffer)str).append(",");
                    }
                    ((StringBuffer)str).append(args[i]);
                }
            }
            ((StringBuffer)str).append(")");
            this.log.debug(((StringBuffer)str).toString());
        }
        try {
            str = this.getNext().invokeHome(invocation);
            return str;
        }
        catch (Throwable e) {
            throw this.handleException(e, invocation);
        }
        finally {
            if (trace) {
                this.log.trace("End method=" + methodName);
            }
        }
    }

    public Object invoke(Invocation invocation) throws Exception {
        Object str;
        String methodName = invocation.getMethod() != null ? invocation.getMethod().getName() : "<no method>";
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("Start method=" + methodName);
        }
        if (this.callLogging) {
            str = new StringBuffer("Invoke: ");
            if (invocation.getId() != null) {
                ((StringBuffer)str).append("[");
                ((StringBuffer)str).append(invocation.getId().toString());
                ((StringBuffer)str).append("] ");
            }
            ((StringBuffer)str).append(methodName);
            ((StringBuffer)str).append("(");
            Object[] args = invocation.getArguments();
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        ((StringBuffer)str).append(",");
                    }
                    ((StringBuffer)str).append(args[i]);
                }
            }
            ((StringBuffer)str).append(")");
            this.log.debug(((StringBuffer)str).toString());
        }
        try {
            str = this.getNext().invoke(invocation);
            return str;
        }
        catch (Throwable e) {
            throw this.handleException(e, invocation);
        }
        finally {
            if (trace) {
                this.log.trace("End method=" + methodName);
            }
        }
    }

    private Exception handleException(Throwable e, Invocation invocation) {
        boolean isLocal;
        InvocationType type = invocation.getType();
        boolean bl = isLocal = type == InvocationType.LOCAL || type == InvocationType.LOCALHOME;
        if (e instanceof TransactionRolledbackLocalException || e instanceof TransactionRolledbackException) {
            if (isLocal && e instanceof TransactionRolledbackException) {
                Exception cause;
                TransactionRolledbackException remoteTxRollback = (TransactionRolledbackException)e;
                if (remoteTxRollback.detail instanceof Exception) {
                    cause = (Exception)remoteTxRollback.detail;
                } else if (remoteTxRollback.detail instanceof Error) {
                    String msg = this.formatException("Unexpected Error", remoteTxRollback.detail);
                    cause = new EJBException(msg);
                } else {
                    String msg = this.formatException("Unexpected Throwable", remoteTxRollback.detail);
                    cause = new EJBException(msg);
                }
                e = new JBossTransactionRolledbackLocalException(remoteTxRollback.getMessage(), cause);
            }
            if (!isLocal && e instanceof TransactionRolledbackLocalException) {
                TransactionRolledbackLocalException localTxRollback = (TransactionRolledbackLocalException)e;
                e = new JBossTransactionRolledbackException(localTxRollback.getMessage(), localTxRollback.getCausedByException());
            }
            Throwable cause = null;
            String exceptionType = null;
            if (e instanceof TransactionRolledbackException) {
                cause = ((TransactionRolledbackException)e).detail;
                exceptionType = "TransactionRolledbackException";
            } else {
                cause = ((TransactionRolledbackLocalException)e).getCausedByException();
                exceptionType = "TransactionRolledbackLocalException";
            }
            if (cause != null) {
                if (cause instanceof EJBException && ((EJBException)cause).getCausedByException() != null) {
                    cause = ((EJBException)cause).getCausedByException();
                }
                this.log.error(exceptionType + " in method: " + invocation.getMethod() + ", causedBy:", cause);
            } else {
                this.log.error(exceptionType + " in method: " + invocation.getMethod(), e);
            }
            return (Exception)e;
        }
        if (e instanceof NoSuchEntityException) {
            NoSuchEntityException noSuchEntityException = (NoSuchEntityException)e;
            if (noSuchEntityException.getCausedByException() != null) {
                this.log.error("NoSuchEntityException in method: " + invocation.getMethod() + ", causedBy:", noSuchEntityException.getCausedByException());
            } else {
                this.log.error("NoSuchEntityException in method: " + invocation.getMethod() + ":", noSuchEntityException);
            }
            if (isLocal) {
                return new NoSuchObjectLocalException(noSuchEntityException.getMessage(), noSuchEntityException.getCausedByException());
            }
            NoSuchObjectException noSuchObjectException = new NoSuchObjectException(noSuchEntityException.getMessage());
            noSuchObjectException.detail = noSuchEntityException;
            return noSuchObjectException;
        }
        if (e instanceof EJBException) {
            EJBException ejbException = (EJBException)e;
            if (ejbException.getCausedByException() != null) {
                this.log.error("EJBException in method: " + invocation.getMethod() + ", causedBy:", ejbException.getCausedByException());
            } else {
                this.log.error("EJBException in method: " + invocation.getMethod() + ":", ejbException);
            }
            if (isLocal) {
                return ejbException;
            }
            return new ServerException("EJBException:", ejbException);
        }
        if (e instanceof SecurityException || e instanceof GeneralSecurityException) {
            Exception runtimeException = (Exception)e;
            if (this.log.isTraceEnabled()) {
                this.log.trace("SecurityException in method: " + invocation.getMethod() + ":", runtimeException);
            }
            if (this.isAppException(invocation, e)) {
                return runtimeException;
            }
            if (isLocal) {
                return new AccessLocalException("SecurityException", runtimeException);
            }
            return new AccessException("SecurityException", runtimeException);
        }
        if (e instanceof JBossLazyUnmarshallingException) {
            RuntimeException runtimeException = (RuntimeException)e;
            this.log.error("UnmarshalException:", e);
            if (isLocal) {
                return new EJBException("UnmarshalException", runtimeException);
            }
            return new MarshalException("MarshalException", runtimeException);
        }
        if (e instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)e;
            this.log.error("RuntimeException in method: " + invocation.getMethod() + ":", runtimeException);
            if (isLocal) {
                return new EJBException("RuntimeException", runtimeException);
            }
            return new ServerException("RuntimeException", runtimeException);
        }
        if (e instanceof Error) {
            this.log.error("Unexpected Error in method: " + invocation.getMethod(), e);
            if (isLocal) {
                String msg = this.formatException("Unexpected Error", e);
                return new EJBException(msg);
            }
            return new ServerError("Unexpected Error", (Error)e);
        }
        if (isLocal && e instanceof RemoteException) {
            if (this.callLogging) {
                this.log.info("Remote Exception in method: " + invocation.getMethod(), e);
            }
            return new EJBException((RemoteException)e);
        }
        if (e instanceof Exception) {
            if (this.callLogging) {
                this.log.info("Application Exception in method: " + invocation.getMethod(), e);
            }
            return (Exception)e;
        }
        String msg = this.formatException("Unexpected Throwable", e);
        this.log.warn("Unexpected Throwable in method: " + invocation.getMethod(), e);
        if (isLocal) {
            return new EJBException(msg);
        }
        return new ServerException(msg);
    }

    private String formatException(String msg, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (msg != null) {
            pw.println(msg);
        }
        if (t != null) {
            t.printStackTrace(pw);
        }
        return sw.toString();
    }
}

