/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.io.InputStream;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.SARDeployerMBean;
import org.jboss.deployment.SubDeployer;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.deployment.XSLSubDeployerMBean;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.util.xml.DOMWriter;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.util.xml.JBossErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XSLSubDeployer
extends SubDeployerSupport
implements XSLSubDeployerMBean {
    protected String xslUrl;
    protected String packageSuffix;
    protected String ddSuffix;
    protected DocumentBuilderFactory dbf;
    private Templates templates;
    protected ObjectName delegateName = SARDeployerMBean.OBJECT_NAME;
    protected SubDeployer delegate;
    private boolean validateDTDs;

    public void setXslUrl(String xslUrl) {
        this.xslUrl = xslUrl;
    }

    public String getXslUrl() {
        return this.xslUrl;
    }

    public void setPackageSuffix(String packageSuffix) {
        this.packageSuffix = packageSuffix;
    }

    public String getPackageSuffix() {
        return this.packageSuffix;
    }

    public void setDdSuffix(String ddSuffix) {
        this.ddSuffix = ddSuffix;
    }

    public String getDdSuffix() {
        return this.ddSuffix;
    }

    public void setDelegateName(ObjectName delegateName) {
        this.delegateName = delegateName;
    }

    public ObjectName getDelegateName() {
        return this.delegateName;
    }

    public boolean getValidateDTDs() {
        return this.validateDTDs;
    }

    public void setValidateDTDs(boolean validate) {
        this.validateDTDs = validate;
    }

    protected void createService() throws Exception {
        super.createService();
        this.delegate = (SubDeployer)MBeanProxyExt.create(SubDeployer.class, this.delegateName, this.server);
        TransformerFactory tf = TransformerFactory.newInstance();
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setNamespaceAware(true);
        this.dbf.setValidating(this.validateDTDs);
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.xslUrl);
        StreamSource ss = new StreamSource(is);
        this.templates = tf.newTemplates(ss);
        this.log.debug("Created templates: " + this.templates);
    }

    protected void destroyService() throws Exception {
        this.templates = null;
        super.destroyService();
    }

    public boolean accepts(DeploymentInfo di) {
        String urlStr = di.url.toString();
        return this.packageSuffix != null && (urlStr.endsWith(this.packageSuffix) || urlStr.endsWith(this.packageSuffix + "/")) || this.ddSuffix != null && urlStr.endsWith(this.ddSuffix);
    }

    public void init(DeploymentInfo di) throws DeploymentException {
        if (di.document == null) {
            this.findDd(di);
        }
        try {
            Transformer trans = this.templates.newTransformer();
            String urlStr = di.url.toString();
            String shortURL = ServerConfigUtil.shortUrlFromServerHome(urlStr);
            trans.setErrorListener(new JBossErrorHandler(shortURL, null));
            DOMSource s = new DOMSource(di.document);
            DOMResult r = new DOMResult();
            this.setParameters(trans);
            trans.transform(s, r);
            di.document = (Document)r.getNode();
            this.log.debug("transformed into doc: " + di.document);
            if (this.log.isDebugEnabled()) {
                String docStr = DOMWriter.printNode(di.document, true);
                this.log.debug("transformed into doc: " + docStr);
            }
        }
        catch (TransformerException ce) {
            throw new DeploymentException("Problem with xsl transformation", ce);
        }
        this.delegate.init(di);
    }

    public void create(DeploymentInfo di) throws DeploymentException {
        this.delegate.create(di);
    }

    public void start(DeploymentInfo di) throws DeploymentException {
        this.delegate.start(di);
    }

    public void stop(DeploymentInfo di) throws DeploymentException {
        this.delegate.stop(di);
    }

    public void destroy(DeploymentInfo di) throws DeploymentException {
        this.delegate.destroy(di);
    }

    protected void setParameters(Transformer trans) throws TransformerException {
    }

    protected void findDd(DeploymentInfo di) throws DeploymentException {
        try {
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            String urlStr = di.url.toString();
            String shortURL = ServerConfigUtil.shortUrlFromServerHome(urlStr);
            JBossEntityResolver resolver = new JBossEntityResolver();
            db.setEntityResolver(resolver);
            db.setErrorHandler(new JBossErrorHandler(shortURL, resolver));
            if (this.ddSuffix != null && urlStr.endsWith(this.ddSuffix)) {
                di.document = db.parse(di.url.openStream());
            }
        }
        catch (SAXException se) {
            throw new DeploymentException("Could not parse dd", se);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Could not read dd", ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new DeploymentException("Could not create document builder for dd", pce);
        }
    }
}

