/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure.file;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.beans.metadata.api.annotations.Install;
import org.jboss.beans.metadata.api.annotations.Uninstall;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.plugins.structure.file.FileMatcher;
import org.jboss.deployers.vfs.spi.structure.VFSStructuralDeployers;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStructure
extends AbstractStructureDeployer {
    private static Set<String> fileSuffixes = new CopyOnWriteArraySet<String>();
    private Set<FileMatcher> fileMatchers = new CopyOnWriteArraySet<FileMatcher>();

    public FileStructure() {
    }

    public FileStructure(Set<String> suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException("Null suffixes");
        }
        fileSuffixes.clear();
        fileSuffixes.addAll(suffixes);
    }

    public Set<String> getSuffixes() {
        return fileSuffixes;
    }

    public static boolean addFileSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        return fileSuffixes.add(suffix);
    }

    public static boolean removeFileSuffix(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("Null suffix");
        }
        return fileSuffixes.remove(suffix);
    }

    @Install
    public boolean addFileMatcher(FileMatcher fm) {
        return this.fileMatchers.add(fm);
    }

    @Uninstall
    public boolean removeFileMatcher(FileMatcher fm) {
        return this.fileMatchers.remove(fm);
    }

    public static boolean isKnownFile(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        for (String suffix : fileSuffixes) {
            if (!name.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkFileMatchers(VirtualFile file) {
        for (FileMatcher fm : this.fileMatchers) {
            if (!fm.isDeployable(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean determineStructure(VirtualFile root, VirtualFile parent, VirtualFile file, StructureMetaData metaData, VFSStructuralDeployers deployers) throws DeploymentException {
        ContextInfo context = null;
        try {
            boolean trace = this.log.isTraceEnabled();
            if (this.isLeaf(file)) {
                boolean isFile = false;
                if (trace) {
                    this.log.trace(file + " is a leaf");
                }
                if (!this.isTopLevel(parent)) {
                    if (!FileStructure.isKnownFile(file.getName()) && !this.checkFileMatchers(file)) {
                        if (trace) {
                            this.log.trace("... no - it is not a top level file and not a known name");
                        }
                    } else {
                        if (trace) {
                            this.log.trace("... ok - not a top level file but it is a known name");
                        }
                        isFile = true;
                    }
                } else {
                    if (trace) {
                        this.log.trace("... ok - it is a top level file");
                    }
                    isFile = true;
                }
                context = this.createContext(file, null, metaData);
                if (trace) {
                    this.log.trace(file + " isFile: " + isFile);
                }
                return isFile;
            }
            if (trace) {
                this.log.trace("... no - not a file.");
            }
            return false;
        }
        catch (Exception e) {
            if (context != null) {
                metaData.removeContext(context);
            }
            throw DeploymentException.rethrowAsDeploymentException("Error determining structure: " + file.getName(), e);
        }
    }

    static {
        fileSuffixes.add("-service.xml");
        fileSuffixes.add("-beans.xml");
        fileSuffixes.add("-ds.xml");
        fileSuffixes.add("-aop.xml");
    }
}

