/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Set;
import java.util.jar.Manifest;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.PackageInformation;
import org.jboss.deployers.structure.spi.classloading.ExportAll;
import org.jboss.deployers.vfs.plugins.classloader.PackageVisitor;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSClassLoaderPolicy
extends ClassLoaderPolicy {
    private static Logger log = Logger.getLogger(VFSClassLoaderPolicy.class);
    private VirtualFile[] roots;
    private ExportAll exportAll;
    private String[] exportedPackages;
    private boolean importAll;

    public static VFSClassLoaderPolicy createVFSClassLoaderPolicy(VirtualFile ... roots) {
        return new VFSClassLoaderPolicy(roots);
    }

    public VFSClassLoaderPolicy(VirtualFile[] roots) {
        if (roots == null) {
            throw new IllegalArgumentException("Null roots");
        }
        for (VirtualFile root : roots) {
            if (root != null) continue;
            throw new IllegalArgumentException("Null root in " + Arrays.asList(roots));
        }
        this.roots = roots;
    }

    public ExportAll isExportAll() {
        return this.exportAll;
    }

    public void setExportAll(ExportAll exportAll) {
        this.exportAll = exportAll;
        this.exportedPackages = exportAll != null ? this.determineAllPackages().toArray(new String[0]) : null;
    }

    @Override
    public boolean isImportAll() {
        return this.importAll;
    }

    public void setImportAll(boolean importAll) {
        this.importAll = importAll;
    }

    @Override
    public String[] getPackageNames() {
        return this.exportedPackages;
    }

    public void setExportedPackages(String[] exportedPackages) {
        this.exportedPackages = exportedPackages;
    }

    @Override
    public URL getResource(String path) {
        VirtualFile child = this.findChild(path);
        if (child != null) {
            try {
                return child.toURL();
            }
            catch (Exception ignored) {
                log.trace("Error determining URL for " + child, ignored);
                return null;
            }
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        VirtualFile child = this.findChild(path);
        if (child != null) {
            try {
                return child.openStream();
            }
            catch (Exception ignored) {
                log.trace("Error opening stream for " + child, ignored);
                return null;
            }
        }
        return null;
    }

    @Override
    public void getResources(String name, Set<URL> urls) throws IOException {
        for (VirtualFile root : this.roots) {
            try {
                VirtualFile child = root.findChild(name);
                urls.add(child.toURL());
            }
            catch (Exception ignored) {
                log.trace("Error getting resources for " + root, ignored);
            }
        }
    }

    protected VirtualFile findChild(String path) {
        for (VirtualFile root : this.roots) {
            try {
                return root.findChild(path);
            }
            catch (Exception ignored) {
            }
        }
        return null;
    }

    @Override
    public PackageInformation getPackageInformation(String packageName) {
        String path = packageName.replace('.', '/');
        VirtualFile pkge = this.findChild(path);
        if (pkge == null) {
            return null;
        }
        try {
            Manifest manifest = VFSUtils.getManifest(pkge.getVFS());
            return new PackageInformation(packageName, manifest);
        }
        catch (IOException ignored) {
            log.trace("Unable to retrieve manifest for " + pkge + " " + ignored.getMessage());
            return null;
        }
    }

    @Override
    protected void toLongString(StringBuilder builder) {
        builder.append(" roots=").append(Arrays.asList(this.roots)).append(" ");
        super.toLongString(builder);
        if (this.exportAll != null) {
            builder.append((Object)this.exportAll);
        }
    }

    @Override
    protected ProtectionDomain getProtectionDomain(String className, String path) {
        VirtualFile clazz = this.findChild(path);
        if (clazz == null) {
            log.trace("Unable to determine class file for " + className);
            return null;
        }
        try {
            VirtualFile root = clazz.getVFS().getRoot();
            URL codeSourceURL = root.toURL();
            Certificate[] certs = null;
            CodeSource cs = new CodeSource(codeSourceURL, certs);
            PermissionCollection permissions = Policy.getPolicy().getPermissions(cs);
            return new ProtectionDomain(cs, permissions);
        }
        catch (Exception e) {
            throw new Error("Error determining protection domain for " + clazz, e);
        }
    }

    protected Set<String> determineAllPackages() {
        PackageVisitor visitor = new PackageVisitor(this.exportAll);
        for (VirtualFile root : this.roots) {
            try {
                visitor.setRoot(root);
                root.visit(visitor);
            }
            catch (Exception e) {
                throw new Error("Error visiting " + root, e);
            }
        }
        return visitor.getPackages();
    }
}

