/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.scope.helpers;

import java.util.ArrayList;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.scope.ScopeBuilder;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;

public class DefaultScopeBuilder
implements ScopeBuilder {
    public static final DefaultScopeBuilder INSTANCE = new DefaultScopeBuilder();

    public ScopeKey getDeploymentScope(DeploymentContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        DeploymentContext top = context.getTopLevel();
        ScopeKey result = ScopeKey.DEFAULT_SCOPE.clone();
        result.addScope(CommonLevels.APPLICATION, top.getName());
        result.addScope(CommonLevels.DEPLOYMENT, context.getName());
        return result;
    }

    public ScopeKey getMutableDeploymentScope(DeploymentContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (context.isTopLevel()) {
            return new ScopeKey(CommonLevels.APPLICATION, context.getName());
        }
        return new ScopeKey(CommonLevels.DEPLOYMENT, context.getName());
    }

    public ScopeKey getComponentScope(DeploymentContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        DeploymentContext parent = context;
        while (parent.isComponent()) {
            parent = context.getParent();
            if (parent != null) continue;
            throw new IllegalStateException("Component has no regular parent?");
        }
        ScopeKey result = parent.getScope().clone();
        result.addScope(CommonLevels.INSTANCE, context.getName());
        return result;
    }

    public ScopeKey getMutableComponentScope(DeploymentContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        return new ScopeKey(CommonLevels.INSTANCE, context.getName());
    }

    public void initMetaDataRetrieval(MutableMetaDataRepository repository, DeploymentContext context) {
        if (repository == null) {
            throw new IllegalArgumentException("Null repository");
        }
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        ScopeKey scopeKey = context.getScope();
        ArrayList<MetaDataRetrieval> retrievals = new ArrayList<MetaDataRetrieval>();
        for (Scope scope : scopeKey.getScopes()) {
            ScopeKey thisScope = new ScopeKey(scope);
            MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(thisScope);
            if (retrieval == null) {
                retrieval = new MemoryMetaDataLoader(thisScope);
                repository.addMetaDataRetrieval(retrieval);
            }
            retrievals.add(0, retrieval);
        }
        AbstractMetaDataContext metaDataContext = new AbstractMetaDataContext(null, retrievals);
        repository.addMetaDataRetrieval(metaDataContext);
    }

    public void initMutableMetaDataRetrieval(MutableMetaDataRepository repository, DeploymentContext context) {
        if (repository == null) {
            throw new IllegalArgumentException("Null repository");
        }
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        ScopeKey scopeKey = context.getMutableScope();
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(scopeKey);
        if (retrieval == null) {
            retrieval = new MemoryMetaDataLoader(scopeKey);
            repository.addMetaDataRetrieval(retrieval);
        }
        AbstractMetaDataContext metaDataContext = new AbstractMetaDataContext(null, retrieval);
        repository.addMetaDataRetrieval(metaDataContext);
    }
}

