/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.helpers;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.List;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.StructureBuilder;
import org.jboss.deployers.structure.spi.helpers.AbstractDeploymentContext;
import org.jboss.logging.Logger;

public class AbstractStructureBuilder
implements StructureBuilder {
    private final Logger log = Logger.getLogger(this.getClass());

    public DeploymentContext populateContext(Deployment deployment, StructureMetaData metaData) throws DeploymentException {
        DeploymentContext result;
        if (deployment == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null metaData");
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("Populating deployment " + deployment.getName() + " metaData=" + metaData);
        }
        try {
            result = this.createRootDeploymentContext(deployment);
            if (result == null) {
                throw new IllegalStateException("Root deployment context is null");
            }
            result.setDeployment(deployment);
            ContextInfo contextInfo = metaData.getContext("");
            if (contextInfo == null) {
                contextInfo = StructureMetaDataFactory.createContextInfo("", null);
            }
            contextInfo.setPredeterminedManagedObjects(deployment.getPredeterminedManagedObjects());
            this.applyContextInfo(result, contextInfo);
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException("Error populating deployment " + deployment.getName(), t);
        }
        try {
            result.getTransientManagedObjects().addAttachment(StructureMetaData.class, metaData);
            this.populateContext(result, metaData);
        }
        catch (Throwable t) {
            result.setProblem(t);
            result.setState(DeploymentState.ERROR);
            this.log.warn("Error populating deployment " + deployment.getName(), t);
        }
        return result;
    }

    protected void populateContext(DeploymentContext context, StructureMetaData metaData) throws Exception {
        List<ContextInfo> contexts;
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null metaData");
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace("Populating Context " + context.getName() + " metaData=" + metaData);
        }
        if ((contexts = metaData.getContexts()) == null) {
            return;
        }
        try {
            for (ContextInfo child : contexts) {
                StructureMetaData childStructure;
                if ("".equals(child.getPath())) continue;
                DeploymentContext childContext = this.createChildDeploymentContext(context, child);
                if (childContext == null) {
                    throw new IllegalStateException("Child deployment context is null");
                }
                context.addChild(childContext);
                childContext.setParent(context);
                this.applyContextInfo(childContext, child);
                Attachments attachments = child.getPredeterminedManagedObjects();
                if (attachments == null || (childStructure = attachments.getAttachment(StructureMetaData.class)) == null) continue;
                this.populateContext(childContext, childStructure);
            }
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException("Error populating context " + context.getName(), t);
        }
    }

    protected void applyContextInfo(DeploymentContext context, ContextInfo contextInfo) throws Exception {
        Attachments attachments = contextInfo.getPredeterminedManagedObjects();
        if (attachments != null) {
            context.setPredeterminedManagedObjects(attachments);
        }
        context.setRelativeOrder(contextInfo.getRelativeOrder());
        this.applyComparator(context, contextInfo);
    }

    protected void applyComparator(DeploymentContext context, ContextInfo contextInfo) throws Exception {
        String className = contextInfo.getComparatorClassName();
        if (className == null) {
            return;
        }
        Object o = null;
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            try {
                Field field = clazz.getField("INSTANCE");
                o = field.get(null);
            }
            catch (NoSuchFieldException ignored) {
                // empty catch block
            }
            if (o == null) {
                o = clazz.newInstance();
            }
            Comparator comparator = (Comparator)Comparator.class.cast(o);
            context.setComparator(comparator);
        }
        catch (Throwable t) {
            this.log.warn("Unable to load/set comparator: " + className);
        }
    }

    protected DeploymentContext createRootDeploymentContext(Deployment deployment) throws Exception {
        return new AbstractDeploymentContext(deployment.getName(), "");
    }

    protected DeploymentContext createChildDeploymentContext(DeploymentContext parent, ContextInfo child) throws Exception {
        String path = child.getPath();
        String name = parent.getName() + "/" + path;
        return new AbstractDeploymentContext(name, path);
    }
}

