/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.helpers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.helpers.AbstractMutableAttachments;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentResourceLoader;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.helpers.ComponentDeploymentContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDeploymentUnit
extends AbstractMutableAttachments
implements DeploymentUnit {
    private static final long serialVersionUID = 1513962148798298768L;
    private DeploymentContext deploymentContext;

    public AbstractDeploymentUnit() {
    }

    public AbstractDeploymentUnit(DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        this.deploymentContext = deploymentContext;
    }

    @Override
    public String getName() {
        return this.deploymentContext.getName();
    }

    @Override
    public Set<Object> getControllerContextNames() {
        return this.deploymentContext.getControllerContextNames();
    }

    @Override
    public void addControllerContextName(Object name) {
        this.deploymentContext.addControllerContextName(name);
    }

    @Override
    public void removeControllerContextName(Object name) {
        this.deploymentContext.removeControllerContextName(name);
    }

    @Override
    public String getSimpleName() {
        return this.deploymentContext.getSimpleName();
    }

    @Override
    public String getRelativePath() {
        return this.deploymentContext.getRelativePath();
    }

    @Override
    public Set<String> getTypes() {
        return this.deploymentContext.getTypes();
    }

    @Override
    public ScopeKey getScope() {
        return this.deploymentContext.getScope();
    }

    @Override
    public void setScope(ScopeKey key) {
        this.deploymentContext.setScope(key);
    }

    @Override
    public ScopeKey getMutableScope() {
        return this.deploymentContext.getMutableScope();
    }

    @Override
    public void setMutableScope(ScopeKey key) {
        this.deploymentContext.setMutableScope(key);
    }

    @Override
    public MetaData getMetaData() {
        return this.deploymentContext.getMetaData();
    }

    @Override
    public MutableMetaData getMutableMetaData() {
        return this.deploymentContext.getMutableMetaData();
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader cl = this.deploymentContext.getClassLoader();
        if (cl == null) {
            throw new IllegalStateException("ClassLoader has not been set");
        }
        this.deploymentContext.deployed();
        return cl;
    }

    @Override
    public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException {
        return this.deploymentContext.createClassLoader(factory);
    }

    @Override
    public void removeClassLoader(ClassLoaderFactory factory) {
        this.deploymentContext.removeClassLoader(factory);
    }

    @Override
    public DeploymentUnit getTopLevel() {
        DeploymentUnit top = this.getParent();
        if (top == null) {
            top = this;
        }
        return top;
    }

    @Override
    public DeploymentUnit getParent() {
        DeploymentContext parent = this.deploymentContext.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getDeploymentUnit();
    }

    @Override
    public List<DeploymentUnit> getChildren() {
        List<DeploymentContext> children = this.deploymentContext.getChildren();
        if (children == null || children.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DeploymentUnit> result = new ArrayList<DeploymentUnit>(children.size());
        for (DeploymentContext child : children) {
            DeploymentUnit unit = child.getDeploymentUnit();
            result.add(unit);
        }
        return result;
    }

    @Override
    public List<DeploymentUnit> getComponents() {
        List<DeploymentContext> components = this.deploymentContext.getComponents();
        if (components == null || components.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DeploymentUnit> result = new ArrayList<DeploymentUnit>(components.size());
        for (DeploymentContext component : components) {
            DeploymentUnit unit = component.getDeploymentUnit();
            result.add(unit);
        }
        return result;
    }

    protected DeploymentContext createComponentDeploymentContext(String name, DeploymentContext parent) {
        return new ComponentDeploymentContext(name, parent);
    }

    protected DeploymentUnit createComponentDeploymentUnit(DeploymentContext component) {
        return new AbstractDeploymentUnit(component);
    }

    @Override
    public boolean isComponent() {
        return this.deploymentContext.isComponent();
    }

    @Override
    public DeploymentUnit addComponent(String name) {
        DeploymentContext component = this.createComponentDeploymentContext(name, this.deploymentContext);
        DeploymentUnit unit = this.createComponentDeploymentUnit(component);
        component.setDeploymentUnit(unit);
        this.deploymentContext.addComponent(component);
        return unit;
    }

    @Override
    public boolean removeComponent(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        for (DeploymentContext component : this.deploymentContext.getComponents()) {
            if (!name.equals(component.getName())) continue;
            return this.deploymentContext.removeComponent(component);
        }
        return false;
    }

    @Override
    public <T> Set<? extends T> getAllMetaData(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        HashSet<T> result = new HashSet<T>();
        Map<String, Object> attachments = this.getAttachments();
        for (Object object : attachments.values()) {
            if (!type.isInstance(object)) continue;
            T t = type.cast(object);
            result.add(t);
        }
        if (!result.isEmpty()) {
            this.deploymentContext.deployed();
        }
        return result;
    }

    @Override
    public MutableAttachments getTransientManagedObjects() {
        return this.deploymentContext.getTransientManagedObjects();
    }

    @Override
    public Object addAttachment(String name, Object attachment) {
        this.deploymentContext.deployed();
        return this.deploymentContext.getTransientAttachments().addAttachment(name, attachment);
    }

    @Override
    public void clear() {
        this.deploymentContext.getTransientAttachments().clear();
        this.deploymentContext.getTransientManagedObjects().clear();
    }

    @Override
    public void clearChangeCount() {
        this.deploymentContext.getTransientAttachments().clearChangeCount();
        this.deploymentContext.getTransientManagedObjects().clearChangeCount();
    }

    @Override
    public int getChangeCount() {
        return this.deploymentContext.getTransientAttachments().getChangeCount() + this.deploymentContext.getTransientManagedObjects().getChangeCount();
    }

    @Override
    public Object removeAttachment(String name) {
        return this.deploymentContext.getTransientAttachments().removeAttachment(name);
    }

    @Override
    public Object getAttachment(String name) {
        Object result;
        DeploymentContext parent = this.deploymentContext.getParent();
        if (!this.deploymentContext.isComponent()) {
            parent = null;
        }
        if ((result = this.deploymentContext.getPredeterminedManagedObjects().getAttachment(name)) != null) {
            this.deploymentContext.deployed();
            return result;
        }
        if (parent != null && (result = parent.getPredeterminedManagedObjects().getAttachment(name)) != null) {
            this.deploymentContext.deployed();
            return result;
        }
        result = this.deploymentContext.getTransientManagedObjects().getAttachment(name);
        if (result != null) {
            this.deploymentContext.deployed();
            return result;
        }
        if (parent != null && (result = parent.getTransientManagedObjects().getAttachment(name)) != null) {
            this.deploymentContext.deployed();
            return result;
        }
        result = this.deploymentContext.getTransientAttachments().getAttachment(name);
        if (result != null) {
            this.deploymentContext.deployed();
            return result;
        }
        if (parent != null && (result = parent.getTransientAttachments().getAttachment(name)) != null) {
            this.deploymentContext.deployed();
            return result;
        }
        return null;
    }

    @Override
    public Map<String, Object> getAttachments() {
        DeploymentContext parent = this.deploymentContext.getParent();
        if (!this.deploymentContext.isComponent()) {
            parent = null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (parent != null) {
            result.putAll(parent.getTransientAttachments().getAttachments());
        }
        result.putAll(this.deploymentContext.getTransientAttachments().getAttachments());
        if (parent != null) {
            result.putAll(parent.getTransientManagedObjects().getAttachments());
        }
        result.putAll(this.deploymentContext.getTransientManagedObjects().getAttachments());
        if (parent != null) {
            result.putAll(parent.getPredeterminedManagedObjects().getAttachments());
        }
        result.putAll(this.deploymentContext.getPredeterminedManagedObjects().getAttachments());
        if (!result.isEmpty()) {
            this.deploymentContext.deployed();
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public boolean hasAttachments() {
        if (this.deploymentContext.getTransientAttachments().hasAttachments()) {
            return true;
        }
        if (this.deploymentContext.getTransientManagedObjects().hasAttachments()) {
            return true;
        }
        if (this.deploymentContext.getPredeterminedManagedObjects().hasAttachments()) {
            return true;
        }
        if (this.deploymentContext.isComponent()) {
            return this.deploymentContext.getParent().getDeploymentUnit().hasAttachments();
        }
        return false;
    }

    @Override
    public boolean isAttachmentPresent(String name) {
        return this.getAttachment(name) != null;
    }

    @Override
    public ClassLoader getResourceClassLoader() {
        return this.deploymentContext.getResourceClassLoader();
    }

    @Override
    public DeploymentResourceLoader getResourceLoader() {
        return this.deploymentContext.getResourceLoader();
    }

    @Override
    public void addIDependOn(DependencyItem dependency) {
        this.getDependencyInfo().addIDependOn(dependency);
    }

    @Override
    public DependencyInfo getDependencyInfo() {
        return this.deploymentContext.getDependencyInfo();
    }

    @Override
    public void removeIDependOn(DependencyItem dependency) {
        this.getDependencyInfo().removeIDependOn(dependency);
    }

    protected DeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.deploymentContext = (DeploymentContext)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.deploymentContext);
    }
}

