/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.classloading;

import org.jboss.deployers.structure.spi.classloading.Version;

public class VersionRange {
    private Version low;
    private boolean lowInclusive;
    private Version high;
    private boolean highInclusive;
    public static final VersionRange ALL_VERSIONS = new VersionRange(Version.DEFAULT_VERSION);

    public VersionRange(Version low) {
        this(low, null);
    }

    public VersionRange(Version low, Version high) {
        this(low, true, high, false);
    }

    public VersionRange(Version low, boolean lowInclusive, Version high, boolean highInclusive) {
        this.low = low;
        this.lowInclusive = lowInclusive;
        this.high = high;
        this.highInclusive = highInclusive;
    }

    public Version getLow() {
        return this.low;
    }

    public boolean isLowInclusive() {
        return this.lowInclusive;
    }

    public Version getHigh() {
        return this.high;
    }

    public boolean isHighInclusive() {
        return this.highInclusive;
    }

    public boolean isInRange(Version version) {
        int comparison;
        if (version == null) {
            throw new IllegalArgumentException("Null version");
        }
        if (this.low != null) {
            comparison = this.low.compareTo(version);
            if (comparison < 0) {
                return false;
            }
            if (!this.lowInclusive && comparison == 0) {
                return false;
            }
        }
        if (this.high != null) {
            comparison = this.high.compareTo(version);
            if (comparison > 0) {
                return false;
            }
            if (!this.highInclusive && comparison == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof VersionRange)) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        Version thisLow = other.getLow();
        Version otherLow = other.getLow();
        if (thisLow == null ? otherLow != null : !thisLow.equals(otherLow)) {
            return false;
        }
        if (thisLow != null && this.isLowInclusive() != other.isLowInclusive()) {
            return false;
        }
        Version thisHigh = other.getHigh();
        Version otherHigh = other.getHigh();
        if (thisHigh == null ? otherHigh != null : !thisHigh.equals(otherHigh)) {
            return false;
        }
        return thisHigh == null || this.isHighInclusive() == other.isHighInclusive();
    }

    public int hashCode() {
        if (this.low != null) {
            return this.low.hashCode();
        }
        if (this.high != null) {
            return this.high.hashCode();
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.low != null) {
            if (this.isLowInclusive()) {
                builder.append("[");
            } else {
                builder.append("(");
            }
            builder.append(this.low);
        } else {
            builder.append("[").append(Version.DEFAULT_VERSION);
        }
        builder.append(",");
        if (this.high != null) {
            builder.append(this.high);
            if (this.isHighInclusive()) {
                builder.append("]");
            } else {
                builder.append(")");
            }
        } else {
            builder.append("inf)");
        }
        return builder.toString();
    }
}

