/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import java.util.ArrayList;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRealDeployerWithInput<T>
extends AbstractRealDeployer {
    private DeploymentVisitor<T> visitor;
    private boolean warned;

    public AbstractRealDeployerWithInput() {
    }

    public AbstractRealDeployerWithInput(Class<T> input) {
        this.setInput(input);
    }

    public Class<? extends T> getInput() {
        Class<?> input = super.getInput();
        if (input == null) {
            throw new IllegalStateException("No input for " + this);
        }
        return input;
    }

    protected void setDeploymentVisitor(DeploymentVisitor<T> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.visitor = visitor;
        Class<T> input = visitor.getVisitorType();
        if (input == null) {
            throw new IllegalArgumentException("Null visitor type");
        }
        this.setInput(input);
    }

    @Override
    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (this.visitor == null) {
            if (!this.warned) {
                this.log.error("INTERNAL ERROR: Visitor is null for " + this.getClass().getName());
                this.warned = true;
            }
            return;
        }
        ArrayList<T> visited = new ArrayList<T>();
        try {
            Set<T> deployments = unit.getAllMetaData(this.getInput());
            for (T deployment : deployments) {
                this.visitor.deploy(unit, deployment);
                visited.add(deployment);
            }
        }
        catch (Throwable t) {
            for (int i = visited.size() - 1; i >= 0; --i) {
                try {
                    this.visitor.undeploy(unit, visited.get(i));
                    continue;
                }
                catch (Throwable ignored) {
                    this.log.warn("Error during undeploy: " + unit.getName(), ignored);
                }
            }
            throw DeploymentException.rethrowAsDeploymentException("Error deploying: " + unit.getName(), t);
        }
    }

    @Override
    public void internalUndeploy(DeploymentUnit unit) {
        if (this.visitor == null) {
            return;
        }
        Set<T> deployments = unit.getAllMetaData(this.getInput());
        for (T deployment : deployments) {
            this.visitor.undeploy(unit, deployment);
        }
    }
}

