/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.microcontainer;

import java.net.URL;
import java.util.Collections;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.InstallCallbackMetaData;
import org.jboss.beans.metadata.plugins.UninstallCallbackMetaData;
import org.jboss.bootstrap.AbstractServerImpl;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.util.StopWatch;

public class ServerImpl
extends AbstractServerImpl {
    public static String BOOTSTRAP_XML_NAME = "bootstrap-beans.xml";
    private BasicBootstrap bootstrap;
    private Kernel kernel;
    private BasicXMLDeployer kernelDeployer;

    public Kernel getKernel() {
        return this.kernel;
    }

    protected void doStart(StopWatch watch) throws Throwable {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        this.kernel = bootstrap.getKernel();
        KernelController controller = this.kernel.getController();
        AbstractBeanMetaData metaData = new AbstractBeanMetaData("JBossServer", this.getClass().getName());
        InstallCallbackMetaData install = new InstallCallbackMetaData();
        install.setMethodName("addBootstrap");
        metaData.setInstallCallbacks(Collections.singletonList(install));
        UninstallCallbackMetaData uninstall = new UninstallCallbackMetaData();
        uninstall.setMethodName("removeBootstrap");
        metaData.setUninstallCallbacks(Collections.singletonList(uninstall));
        controller.install(metaData, this);
        URL url = this.getConfig().getBootstrapURL();
        if (url == null) {
            URL configURL = this.getConfig().getServerConfigURL();
            url = new URL(configURL, BOOTSTRAP_XML_NAME);
            this.log.info("Starting Microcontainer, bootstrapURL=" + url);
        }
        this.kernelDeployer = new BasicXMLDeployer(this.kernel);
        this.kernelDeployer.deploy(url);
        this.kernelDeployer.validate();
        KernelEvent startEvent = bootstrap.createEvent("org.jboss.system.server.started", new Long(watch.getLapTime()));
        bootstrap.fireKernelEvent(startEvent);
        this.bootstrap = bootstrap;
    }

    protected void doShutdown() {
        try {
            if (this.bootstrap != null) {
                KernelEvent stopEvent = this.bootstrap.createEvent("org.jboss.system.server.stopped", null);
                this.bootstrap.fireKernelEvent(stopEvent);
            }
        }
        catch (Throwable t) {
            this.log.warn("Error sending stop notification", t);
        }
        try {
            if (this.kernelDeployer != null) {
                this.kernelDeployer.shutdown();
                this.kernelDeployer = null;
            }
        }
        catch (Throwable t) {
            this.log.warn("Error stopping xml deployer", t);
        }
        try {
            Kernel currentKernel = null;
            if (this.kernel != null) {
                currentKernel = this.kernel;
                this.kernel = null;
            } else if (this.bootstrap != null) {
                currentKernel = this.bootstrap.getKernel();
            }
            this.bootstrap = null;
            if (currentKernel != null) {
                KernelController controller = currentKernel.getController();
                controller.shutdown();
            }
        }
        catch (Throwable t) {
            this.log.warn("Error stopping xml deployer", t);
        }
    }
}

