/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.aspects.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;

public class JMXIntroduction
implements Interceptor {
    private static final Logger log = Logger.getLogger(JMXIntroduction.class);
    private MBeanServer server;

    public String getName() {
        return this.getClass().getName();
    }

    public void setMbeanServer(MBeanServer server) {
        this.server = server;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        String jmxName;
        MethodInvocation mi = (MethodInvocation)invocation;
        KernelControllerContext context = (KernelControllerContext)mi.getArguments()[0];
        JMX jmx = (JMX)invocation.resolveClassAnnotation(JMX.class);
        ObjectName objectName = null;
        if (jmx != null && (jmxName = jmx.name()) != null && jmxName.length() > 0) {
            objectName = new ObjectName(jmxName);
        }
        if (objectName == null) {
            String name = (String)context.getName();
            objectName = name.contains(":") ? new ObjectName(name) : new ObjectName("test:name='" + name + "'");
        }
        if (this.server == null) {
            throw new RuntimeException("No MBeanServer was injected");
        }
        if ("setKernelControllerContext".equals(mi.getMethod().getName())) {
            Class intfClass = null;
            boolean registerDirectly = false;
            if (jmx != null) {
                intfClass = jmx.exposedInterface();
                registerDirectly = jmx.registerDirectly();
            }
            Object mbean = registerDirectly ? context.getTarget() : new StandardMBean(context.getTarget(), intfClass);
            this.server.registerMBean(mbean, objectName);
            log.info("Registered MBean " + objectName);
        } else {
            log.info("Unregistering MBean " + objectName);
            this.server.unregisterMBean(objectName);
        }
        return null;
    }
}

