/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.advice.AdviceType;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.GenericInterceptorFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.PerInstanceInterceptor;
import org.jboss.aop.advice.PerJoinpointInterceptor;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;

public class ScopedInterceptorFactory
implements InterceptorFactory {
    private AspectDefinition aspect;

    public ScopedInterceptorFactory(AspectDefinition aspect) {
        this.aspect = aspect;
    }

    public AspectDefinition getAspect() {
        return this.aspect;
    }

    public String getAdvice() {
        return "invoke";
    }

    public AdviceType getType() {
        return AdviceType.AROUND;
    }

    public boolean isDeployed() {
        return this.aspect.isDeployed();
    }

    public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
        if (this.aspect.getScope() == Scope.PER_VM) {
            return (Interceptor)advisor.getManager().getPerVMAspect(this.aspect);
        }
        if (this.aspect.getScope() == Scope.PER_CLASS) {
            Interceptor interceptor = advisor.getAdviceInterceptor(this.aspect, "invoke", null);
            if (interceptor != null) {
                return interceptor;
            }
            advisor.addPerClassAspect(this.aspect);
            interceptor = (Interceptor)advisor.getPerClassAspect(this.aspect);
            advisor.addAdviceInterceptor(this.aspect, "invoke", interceptor, null);
            return interceptor;
        }
        if (this.aspect.getScope() == Scope.PER_INSTANCE) {
            return new PerInstanceInterceptor(this.aspect, advisor);
        }
        if (this.aspect.getScope() == Scope.PER_JOINPOINT) {
            try {
                return PerJoinpointInterceptor.createInterceptor(advisor, joinpoint, this.aspect);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.aspect.getScope() == Scope.PER_CLASS_JOINPOINT) {
            if (advisor instanceof GeneratedClassAdvisor) {
                Object icptr = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(this.aspect, joinpoint);
                if (icptr == null) {
                    ((GeneratedClassAdvisor)advisor).addPerClassJoinpointAspect(this.aspect, joinpoint);
                    icptr = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(this.aspect, joinpoint);
                }
                return (Interceptor)icptr;
            }
            if (joinpoint instanceof FieldJoinpoint) {
                FieldJoinpoint field = (FieldJoinpoint)joinpoint;
                ClassAdvisor classAdvisor = (ClassAdvisor)advisor;
                return (Interceptor)classAdvisor.getFieldAspect(field, this.aspect);
            }
            return (Interceptor)this.aspect.getFactory().createPerJoinpoint(advisor, joinpoint);
        }
        return null;
    }

    public String getName() {
        return this.aspect.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScopedInterceptorFactory)) {
            return false;
        }
        AspectDefinition otherAspect = ((GenericInterceptorFactory)obj).getAspect();
        if (!this.aspect.getName().equals(otherAspect.getName())) {
            return false;
        }
        return this.aspect.getFactory().getName().equals(otherAspect.getFactory().getName());
    }
}

