/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testng;

import java.lang.reflect.Method;
import java.util.Stack;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.jboss.arquillian.test.spi.TestRunnerAdaptorBuilder;
import org.jboss.arquillian.test.spi.execution.SkippedTestExecutionException;
import org.jboss.arquillian.testng.State;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Listeners;

@Listeners(value={UpdateResultListener.class})
public abstract class Arquillian
implements IHookable {
    public static final String ARQUILLIAN_DATA_PROVIDER = "ARQUILLIAN_DATA_PROVIDER";
    private static ThreadLocal<TestRunnerAdaptor> deployableTest = new ThreadLocal();
    private static ThreadLocal<Stack<Cycle>> cycleStack = new ThreadLocal<Stack<Cycle>>(){

        @Override
        protected Stack<Cycle> initialValue() {
            return new Stack<Cycle>();
        }
    };

    @BeforeSuite(groups={"arquillian"}, inheritGroups=true)
    public void arquillianBeforeSuite() throws Exception {
        if (deployableTest.get() == null) {
            TestRunnerAdaptor adaptor = TestRunnerAdaptorBuilder.build();
            adaptor.beforeSuite();
            deployableTest.set(adaptor);
            cycleStack.get().push(Cycle.BEFORE_SUITE);
        }
    }

    @AfterSuite(groups={"arquillian"}, inheritGroups=true, alwaysRun=true)
    public void arquillianAfterSuite() throws Exception {
        if (deployableTest.get() == null) {
            return;
        }
        if (cycleStack.get().empty()) {
            return;
        }
        if (cycleStack.get().peek() != Cycle.BEFORE_SUITE) {
            return;
        }
        cycleStack.get().pop();
        deployableTest.get().afterSuite();
        deployableTest.get().shutdown();
        deployableTest.set(null);
        deployableTest.remove();
        cycleStack.set(null);
        cycleStack.remove();
    }

    @BeforeClass(groups={"arquillian"}, inheritGroups=true)
    public void arquillianBeforeClass() throws Exception {
        this.verifyTestRunnerAdaptorHasBeenSet();
        cycleStack.get().push(Cycle.BEFORE_CLASS);
        deployableTest.get().beforeClass(this.getClass(), LifecycleMethodExecutor.NO_OP);
    }

    @AfterClass(groups={"arquillian"}, inheritGroups=true, alwaysRun=true)
    public void arquillianAfterClass() throws Exception {
        if (cycleStack.get().empty()) {
            return;
        }
        if (cycleStack.get().peek() != Cycle.BEFORE_CLASS) {
            return;
        }
        cycleStack.get().pop();
        this.verifyTestRunnerAdaptorHasBeenSet();
        deployableTest.get().afterClass(this.getClass(), LifecycleMethodExecutor.NO_OP);
    }

    @BeforeMethod(groups={"arquillian"}, inheritGroups=true)
    public void arquillianBeforeTest(Method testMethod) throws Exception {
        this.verifyTestRunnerAdaptorHasBeenSet();
        cycleStack.get().push(Cycle.BEFORE);
        deployableTest.get().before((Object)this, testMethod, LifecycleMethodExecutor.NO_OP);
    }

    @AfterMethod(groups={"arquillian"}, inheritGroups=true, alwaysRun=true)
    public void arquillianAfterTest(Method testMethod) throws Exception {
        if (cycleStack.get().empty()) {
            return;
        }
        if (cycleStack.get().peek() != Cycle.BEFORE) {
            return;
        }
        cycleStack.get().pop();
        this.verifyTestRunnerAdaptorHasBeenSet();
        deployableTest.get().after((Object)this, testMethod, LifecycleMethodExecutor.NO_OP);
    }

    public void run(final IHookCallBack callback, final ITestResult testResult) {
        this.verifyTestRunnerAdaptorHasBeenSet();
        try {
            TestResult result = deployableTest.get().test(new TestMethodExecutor(){

                public void invoke(Object ... parameters) throws Throwable {
                    this.copyParameters(parameters, callback.getParameters());
                    callback.runTestMethod(testResult);
                    this.swapWithClassNames(callback.getParameters());
                    testResult.setParameters(callback.getParameters());
                    if (testResult.getThrowable() != null) {
                        throw testResult.getThrowable();
                    }
                }

                private void copyParameters(Object[] source, Object[] target) {
                    for (int i = 0; i < source.length; ++i) {
                        if (source[i] == null) continue;
                        target[i] = source[i];
                    }
                }

                private void swapWithClassNames(Object[] source) {
                    for (int i = 0; source != null && i < source.length; ++i) {
                        Object parameter = source[i];
                        source[i] = parameter != null ? parameter.toString() : "null";
                    }
                }

                public Method getMethod() {
                    return testResult.getMethod().getMethod();
                }

                public Object getInstance() {
                    return Arquillian.this;
                }
            });
            Throwable throwable = result.getThrowable();
            if (throwable != null) {
                if (result.getStatus() == TestResult.Status.SKIPPED && throwable instanceof SkippedTestExecutionException) {
                    result.setThrowable((Throwable)new SkipException(throwable.getMessage()));
                }
                testResult.setThrowable(result.getThrowable());
                testResult.setStatus(2);
            }
            testResult.setEndMillis(result.getStart() - result.getEnd() + testResult.getStartMillis());
        }
        catch (Exception e) {
            testResult.setThrowable((Throwable)e);
        }
    }

    @DataProvider(name="ARQUILLIAN_DATA_PROVIDER")
    public Object[][] arquillianArgumentProvider(Method method) {
        Object[][] values = new Object[1][method.getParameterTypes().length];
        if (deployableTest.get() == null) {
            return values;
        }
        Object[] parameterValues = new Object[method.getParameterTypes().length];
        values[0] = parameterValues;
        return values;
    }

    private void verifyTestRunnerAdaptorHasBeenSet() {
        if (deployableTest.get() == null) {
            throw new IllegalStateException("No TestRunnerAdaptor found, @BeforeSuite has not been called");
        }
    }

    public static final class UpdateResultListener
    implements IInvokedMethodListener {
        public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
            if (method.isTestMethod() && testResult.getStatus() != 1) {
                State.caughtExceptionAfter(testResult.getThrowable());
            }
        }

        public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Cycle {
        BEFORE_SUITE,
        BEFORE_CLASS,
        BEFORE,
        TEST,
        AFTER,
        AFTER_CLASS,
        AFTER_SUITE;

    }
}

