/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.context.GrapheneContextImpl;
import org.jboss.arquillian.graphene.intercept.InterceptorPrecedenceComparator;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyUtil;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.arquillian.graphene.proxy.InvocationContextImpl;
import org.jboss.arquillian.graphene.shaded.net.sf.cglib.proxy.MethodProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrapheneContextualHandler
extends GrapheneProxyHandler {
    private final GrapheneContext context;
    private Map<Class<?>, Interceptor> interceptors = new HashMap();

    private GrapheneContextualHandler(GrapheneContext context, Object target) {
        super(target);
        this.context = context;
    }

    private GrapheneContextualHandler(GrapheneContext context, GrapheneProxy.FutureTarget future) {
        super(future);
        this.context = context;
    }

    public static GrapheneContextualHandler forTarget(GrapheneContext context, Object target) {
        GrapheneContextualHandler handler = new GrapheneContextualHandler(context, target);
        return handler;
    }

    public static GrapheneContextualHandler forFuture(GrapheneContext context, GrapheneProxy.FutureTarget future) {
        GrapheneContextualHandler handler = new GrapheneContextualHandler(context, future);
        return handler;
    }

    @Override
    public Object invoke(final Object proxy, final Method method, final Object[] args) throws Throwable {
        Interceptor interceptor;
        Object target;
        if (method.getName().equals("finalize") && method.getParameterTypes().length == 0) {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if ((target = this.getTarget()) instanceof GrapheneProxyInstance) {
                return ((GrapheneProxyInstance)target).unwrap();
            }
            method.invoke(target, new Object[0]);
        }
        if (method.equals(GrapheneProxyInstance.class.getMethod("unwrap", new Class[0]))) {
            target = this.getTarget();
            if (target instanceof GrapheneProxyInstance) {
                return ((GrapheneProxyInstance)target).unwrap();
            }
            return target;
        }
        if (method.equals(GrapheneProxyInstance.class.getMethod("registerInterceptor", Interceptor.class))) {
            interceptor = (Interceptor)args[0];
            if (interceptor == null) {
                throw new IllegalArgumentException("The parameter [interceptor] is null.");
            }
            this.interceptors.put(interceptor.getClass(), interceptor);
            return null;
        }
        if (method.equals(GrapheneProxyInstance.class.getMethod("unregisterInterceptor", Interceptor.class))) {
            interceptor = (Interceptor)args[0];
            if (interceptor == null) {
                throw new IllegalArgumentException("The parameter [interceptor] is null.");
            }
            return this.interceptors.remove(interceptor.getClass());
        }
        if (method.equals(GrapheneProxyInstance.class.getMethod("copy", new Class[0]))) {
            GrapheneProxyInstance clone = (GrapheneProxyInstance)GrapheneProxy.getProxyForTarget(this.context, this.getTarget());
            for (Interceptor interceptor2 : this.getSortedInterceptorsByPrecedence()) {
                clone.registerInterceptor(interceptor2);
            }
            return clone;
        }
        if (method.equals(GrapheneProxyInstance.class.getMethod("getHandler", new Class[0]))) {
            return this;
        }
        if (method.equals(GrapheneProxyInstance.class.getMethod("getGrapheneContext", new Class[0]))) {
            return this.context;
        }
        InvocationContext invocationContext = new InvocationContext(){

            public Object invoke() throws Throwable {
                Object result = GrapheneContextualHandler.this.invokeReal(this.getTarget(), method, args);
                if (result == null) {
                    return null;
                }
                if (GrapheneContextualHandler.this.isProxyable(method, args) && !(result instanceof GrapheneProxyInstance)) {
                    Class<?>[] interfaces = GrapheneProxyUtil.getInterfaces(result.getClass());
                    Object newProxy = GrapheneProxy.getProxyForTargetWithInterfaces(GrapheneContextualHandler.this.context, result, interfaces);
                    return newProxy;
                }
                return result;
            }

            public Method getMethod() {
                return method;
            }

            public Object[] getArguments() {
                return args;
            }

            public Object getTarget() {
                return GrapheneContextualHandler.this.getTarget();
            }

            public Object getProxy() {
                return proxy;
            }

            public GrapheneContext getGrapheneContext() {
                return GrapheneContextualHandler.this.context;
            }
        };
        for (Interceptor interceptor3 : this.getSortedInterceptorsByPrecedence()) {
            invocationContext = new InvocationContextImpl(interceptor3, invocationContext);
        }
        final InvocationContext finalInvocationContext = invocationContext;
        if (this.context != null) {
            return ((GrapheneContextImpl)this.context).getBrowserActions().performAction(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        return finalInvocationContext.invoke();
                    }
                    catch (Throwable e) {
                        if (e instanceof Exception) {
                            throw (Exception)e;
                        }
                        if (e instanceof AssertionError) {
                            throw (AssertionError)((Object)e);
                        }
                        throw new IllegalStateException("Can't invoke method " + method.getName() + ".", e);
                    }
                }
            });
        }
        return finalInvocationContext.invoke();
    }

    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return this.invoke(obj, method, args);
    }

    public void resetInterceptors() {
        this.interceptors.clear();
    }

    private List<Interceptor> getSortedInterceptorsByPrecedence() {
        ArrayList<Interceptor> result = new ArrayList<Interceptor>(this.interceptors.values());
        Collections.sort(result, new InterceptorPrecedenceComparator());
        return result;
    }
}

