/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.locator;

import java.util.logging.Logger;
import org.jboss.arquillian.core.spi.Validate;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLocatorBooleanCondition
implements ExpectedCondition<Boolean> {
    protected static final Logger LOGGER = Logger.getLogger(AbstractLocatorBooleanCondition.class.getName());
    private final boolean negation;
    private final By locator;

    public AbstractLocatorBooleanCondition(By locator) {
        this(locator, false);
    }

    public AbstractLocatorBooleanCondition(By locator, boolean negation) {
        Validate.notNull((Object)locator, (String)"The locator can't be null.");
        this.locator = locator;
        this.negation = negation;
    }

    public Boolean apply(WebDriver driver) {
        if (this.negation) {
            return !this.check(driver);
        }
        return this.check(driver);
    }

    protected boolean getNegation() {
        return this.negation;
    }

    protected By getLocator() {
        return this.locator;
    }

    protected abstract boolean check(WebDriver var1);
}

