/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.seam2.configuration;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationTypeConverter {
    ConfigurationTypeConverter() {
    }

    public Class<?> box(Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            return primitive;
        }
        if (Integer.TYPE.equals(primitive)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitive)) {
            return Long.class;
        }
        if (Float.TYPE.equals(primitive)) {
            return Float.class;
        }
        if (Double.TYPE.equals(primitive)) {
            return Double.class;
        }
        if (Short.TYPE.equals(primitive)) {
            return Short.class;
        }
        if (Boolean.TYPE.equals(primitive)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(primitive)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(primitive)) {
            return Byte.class;
        }
        throw new IllegalArgumentException("Unknown primitive type " + primitive);
    }

    public <T> T convert(String value, Class<T> to) {
        if (String.class.equals(to)) {
            return to.cast(value);
        }
        if (Integer.class.equals(to)) {
            return to.cast(Integer.valueOf(value));
        }
        if (Double.class.equals(to)) {
            return to.cast(Double.valueOf(value));
        }
        if (Long.class.equals(to)) {
            return to.cast(Long.valueOf(value));
        }
        if (Boolean.class.equals(to)) {
            return to.cast(Boolean.valueOf(value));
        }
        if (URL.class.equals(to)) {
            try {
                return to.cast(new URI(value).toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        if (URI.class.equals(to)) {
            try {
                return to.cast(new URI(value));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to convert value " + value + " to URL", e);
            }
        }
        throw new IllegalArgumentException("Unable to convert value " + value + "to a class: " + to.getName());
    }
}

