/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.impl.CachingCallableImpl;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.CachingCallable;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.spi.command.PrepareDrone;
import org.jboss.arquillian.drone.spi.event.AfterDroneCallableCreated;
import org.jboss.arquillian.drone.spi.event.AfterDroneConfigured;
import org.jboss.arquillian.drone.spi.event.BeforeDroneCallableCreated;
import org.jboss.arquillian.drone.spi.event.BeforeDroneConfigured;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneConfigurator {
    private static Logger logger = Logger.getLogger(DroneConfigurator.class.getName());
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Instance<ArquillianDescriptor> arquillianDescriptor;
    @Inject
    private Event<BeforeDroneConfigured> beforeDroneConfiguredEvent;
    @Inject
    private Event<AfterDroneConfigured> afterDroneConfiguredEvent;
    @Inject
    private Event<BeforeDroneCallableCreated> beforeDroneCallableCreatedEvent;
    @Inject
    private Event<AfterDroneCallableCreated> afterDroneCallableCreatedEvent;

    public void prepareDrone(@Observes PrepareDrone command, DroneRegistry registry) {
        DronePoint dronePoint = command.getDronePoint();
        this.configureDrone(registry, dronePoint);
        this.createDroneCallable(registry, dronePoint);
    }

    private <DRONE> void configureDrone(DroneRegistry registry, DronePoint<DRONE> dronePoint) {
        ArquillianDescriptor descriptor = (ArquillianDescriptor)this.arquillianDescriptor.get();
        DroneContext context = (DroneContext)this.droneContext.get();
        Validate.stateNotNull(descriptor, "ArquillianDescriptor should not be null", new Object[0]);
        Validate.stateNotNull(context, "DroneContext should be available while working with method scoped instances", new Object[0]);
        if (context.get(dronePoint).hasConfiguration()) {
            logger.log(Level.WARNING, "Could not configure drone for injection point {0}, because it was already configured!", dronePoint);
            return;
        }
        Configurator configurator = (Configurator)registry.getEntryFor(dronePoint.getDroneType(), Configurator.class);
        this.beforeDroneConfiguredEvent.fire((Object)new BeforeDroneConfigured(configurator, dronePoint));
        if (!context.get(dronePoint).hasConfiguration()) {
            DroneConfiguration configuration = configurator.createConfiguration(descriptor, dronePoint);
            context.get(dronePoint).setConfiguration(configuration);
        }
        this.afterDroneConfiguredEvent.fire((Object)new AfterDroneConfigured(dronePoint));
    }

    private <DRONE> void createDroneCallable(DroneRegistry registry, final DronePoint<DRONE> dronePoint) {
        final DroneContext context = (DroneContext)this.droneContext.get();
        if (context.get(dronePoint).hasFutureInstance()) {
            logger.log(Level.WARNING, "Could not create drone callable for injection point {0}, because it was already created!", dronePoint);
            return;
        }
        final Instantiator instantiator = (Instantiator)registry.getEntryFor(dronePoint.getDroneType(), Instantiator.class);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using instantiator defined in class: " + instantiator.getClass().getName() + ", " + "with precedence " + instantiator.getPrecedence());
        }
        this.beforeDroneCallableCreatedEvent.fire((Object)new BeforeDroneCallableCreated(instantiator, dronePoint));
        CachingCallableImpl futureDrone = new CachingCallableImpl<DRONE>(){

            @Override
            protected DRONE createInstance() throws Exception {
                DroneConfiguration configuration = context.get(dronePoint).getConfigurationAs(DroneConfiguration.class);
                return instantiator.createInstance(configuration);
            }
        };
        context.get(dronePoint).setFutureInstance((CachingCallable)futureDrone);
        this.afterDroneCallableCreatedEvent.fire((Object)new AfterDroneCallableCreated(dronePoint));
    }
}

