/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.arquillian.drone.spi.CachingCallable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachingCallableImpl<V>
implements CachingCallable<V> {
    private final AtomicBoolean valueCached = new AtomicBoolean();
    private V cachedValue;

    public boolean isValueCached() {
        return this.valueCached.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V call() throws Exception {
        if (this.isValueCached()) {
            return this.cachedValue;
        }
        AtomicBoolean atomicBoolean = this.valueCached;
        synchronized (atomicBoolean) {
            if (!this.valueCached.get()) {
                this.cachedValue = this.createInstance();
                this.valueCached.set(true);
            }
        }
        return this.cachedValue;
    }

    protected abstract V createInstance() throws Exception;
}

