/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.spi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.SecurityActions;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.core.spi.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerBuilder {
    private static final String MANAGER_IMPL_CLASS = "org.jboss.arquillian.core.impl.ManagerImpl";
    private Set<Class<? extends Context>> contexts = new HashSet<Class<? extends Context>>();
    private Set<Class<?>> extensions = new HashSet();

    private ManagerBuilder() {
    }

    public static ManagerBuilder from() {
        return new ManagerBuilder();
    }

    public ManagerBuilder context(Class<? extends Context> context) {
        Validate.notNull(context, "Context must be specified");
        this.contexts.add(context);
        return this;
    }

    public ManagerBuilder extensions(Class<?> ... extensions) {
        Validate.notNull(extensions, "Extensions must be specified");
        for (Class<?> extension : extensions) {
            this.extension(extension);
        }
        return this;
    }

    public ManagerBuilder extension(Class<?> extension) {
        Validate.notNull(extension, "Extension must be specified");
        this.extensions.add(extension);
        return this;
    }

    public Manager create() {
        return SecurityActions.newInstance(MANAGER_IMPL_CLASS, new Class[]{Collection.class, Collection.class}, new Object[]{this.contexts, this.extensions}, Manager.class);
    }
}

