/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.jetty;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJettyEmbeddedConfiguration
implements ContainerConfiguration {
    private String bindAddress = "localhost";
    private int bindHttpPort = 9090;
    private Map<String, String> mimeTypes;
    private int headerBufferSize = 0;
    private File realmProperties;
    private String configurationClasses;

    public void validate() throws ConfigurationException {
        if (this.realmProperties != null) {
            if (!this.realmProperties.exists()) {
                throw new ConfigurationException(String.format("Realm properties file %s must exists.", this.realmProperties.getAbsolutePath()));
            }
            if (this.realmProperties.isDirectory()) {
                throw new ConfigurationException("Realm Properties should be a file and not a directory");
            }
        }
    }

    public int getBindHttpPort() {
        return this.bindHttpPort;
    }

    public void setBindHttpPort(int bindHttpPort) {
        this.bindHttpPort = bindHttpPort;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public String getConfigurationClasses() {
        return this.configurationClasses;
    }

    public void setConfigurationClasses(String configurationClasses) {
        this.configurationClasses = configurationClasses;
    }

    public int getHeaderBufferSize() {
        return this.headerBufferSize;
    }

    public boolean isHeaderBufferSizeSet() {
        return this.headerBufferSize > 0;
    }

    public void setHeaderBufferSize(int headerBufferSize) {
        this.headerBufferSize = headerBufferSize;
    }

    public void setRealmProperties(String realmProperties) {
        this.realmProperties = new File(realmProperties);
    }

    public boolean isRealmPropertiesFileSet() {
        return this.realmProperties != null;
    }

    public File getRealmProperties() {
        return this.realmProperties;
    }

    public void setMimeTypes(String mimeTypes) {
        this.mimeTypes = new HashMap<String, String>();
        String[] splittedLines = mimeTypes.split(" ");
        for (int i = 0; i < splittedLines.length; i += 2) {
            if (i + 1 >= splittedLines.length) {
                throw new ConfigurationException(String.format("Mime Type definition should follow the format <extension> <type>[ <extension> <type>]*, for example js application/javascript but %s definition has been found.", mimeTypes));
            }
            this.mimeTypes.put(splittedLines[i], splittedLines[i + 1]);
        }
    }

    public boolean areMimeTypesSet() {
        return this.mimeTypes != null;
    }

    public Map<String, String> getMimeTypes() {
        return this.mimeTypes;
    }
}

