/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractNonInteractiveCredentialsAction
extends AbstractAction {
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;

    protected final boolean isRenewPresent(RequestContext context) {
        return StringUtils.hasText((String)context.getRequestParameters().get("renew"));
    }

    protected final Event doExecute(RequestContext context) {
        Credential credential = this.constructCredentialsFromRequest(context);
        if (credential == null) {
            return this.error();
        }
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId(context);
        WebApplicationService service = WebUtils.getService(context);
        if (this.isRenewPresent(context) && ticketGrantingTicketId != null && service != null) {
            try {
                String serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, service, credential);
                WebUtils.putServiceTicketInRequestScope(context, serviceTicketId);
                return this.result("warn");
            }
            catch (AuthenticationException e) {
                this.onError(context, credential);
                return this.error();
            }
            catch (TicketException e) {
                this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
                this.logger.debug((Object)"Attempted to generate a ServiceTicket using renew=true with different credential", (Throwable)e);
            }
        }
        try {
            WebUtils.putTicketGrantingTicketInRequestScope(context, this.centralAuthenticationService.createTicketGrantingTicket(credential));
            this.onSuccess(context, credential);
            return this.success();
        }
        catch (Exception e) {
            this.onError(context, credential);
            return this.error();
        }
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    protected void onError(RequestContext context, Credential credential) {
    }

    protected void onSuccess(RequestContext context, Credential credential) {
    }

    protected abstract Credential constructCredentialsFromRequest(RequestContext var1);
}

