/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.support;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceAttributeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisteredServiceDefaultAttributeFilter
implements RegisteredServiceAttributeFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Map<String, Object> filter(String principalId, Map<String, Object> givenAttributes, RegisteredService registeredService) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (registeredService.isIgnoreAttributes()) {
            this.logger.debug("Service [{}] is set to ignore attribute release policy. Releasing all attributes.", (Object)registeredService.getName());
            attributes.putAll(givenAttributes);
        } else {
            for (String attribute : registeredService.getAllowedAttributes()) {
                Object value = givenAttributes.get(attribute);
                if (value == null) continue;
                this.logger.debug("Found attribute [{}] in the list of allowed attributes for service [{}]", (Object)attribute, (Object)registeredService.getName());
                attributes.put(attribute, value);
            }
        }
        return Collections.unmodifiableMap(attributes);
    }
}

