/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.logout;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.Deflater;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.binary.Base64;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SingleLogoutService;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.logout.LogoutMessageCreator;
import org.jasig.cas.logout.LogoutRequest;
import org.jasig.cas.logout.LogoutRequestStatus;
import org.jasig.cas.services.LogoutType;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogoutManagerImpl
implements LogoutManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutManagerImpl.class);
    private static final Charset ASCII = Charset.forName("ASCII");
    @NotNull
    private final ServicesManager servicesManager;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final LogoutMessageCreator logoutMessageBuilder;
    private boolean disableSingleSignOut = false;

    public LogoutManagerImpl(ServicesManager servicesManager, HttpClient httpClient, LogoutMessageCreator logoutMessageBuilder) {
        this.servicesManager = servicesManager;
        this.httpClient = httpClient;
        this.logoutMessageBuilder = logoutMessageBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogoutRequest> performLogout(TicketGrantingTicket ticket) {
        Map<String, Service> services;
        TicketGrantingTicket ticketGrantingTicket = ticket;
        synchronized (ticketGrantingTicket) {
            services = ticket.getServices();
            ticket.removeAllServices();
        }
        ticket.markTicketExpired();
        ArrayList<LogoutRequest> logoutRequests = new ArrayList<LogoutRequest>();
        if (!this.disableSingleSignOut) {
            for (String ticketId : services.keySet()) {
                SingleLogoutService singleLogoutService;
                Service service = services.get(ticketId);
                if (!(service instanceof SingleLogoutService) || (singleLogoutService = (SingleLogoutService)service).isLoggedOutAlready()) continue;
                LogoutRequest logoutRequest = new LogoutRequest(ticketId, singleLogoutService);
                logoutRequests.add(logoutRequest);
                RegisteredService registeredService = this.servicesManager.findServiceBy(service);
                if (registeredService != null && registeredService.getLogoutType() != null && registeredService.getLogoutType() != LogoutType.BACK_CHANNEL) continue;
                if (this.performBackChannelLogout(logoutRequest)) {
                    logoutRequest.setStatus(LogoutRequestStatus.SUCCESS);
                    continue;
                }
                logoutRequest.setStatus(LogoutRequestStatus.FAILURE);
                LOGGER.warn("Logout message not sent to [{}]; Continuing processing...", (Object)singleLogoutService.getId());
            }
        }
        return logoutRequests;
    }

    private boolean performBackChannelLogout(LogoutRequest request) {
        String logoutRequest = this.logoutMessageBuilder.create(request);
        request.getService().setLoggedOutAlready(true);
        LOGGER.debug("Sending logout request for: [{}]", (Object)request.getService().getId());
        return this.httpClient.sendMessageToEndPoint(request.getService().getOriginalUrl(), logoutRequest, true);
    }

    @Override
    public String createFrontChannelLogoutMessage(LogoutRequest logoutRequest) {
        String logoutMessage = this.logoutMessageBuilder.create(logoutRequest);
        Deflater deflater = new Deflater();
        deflater.setInput(logoutMessage.getBytes(ASCII));
        deflater.finish();
        byte[] buffer = new byte[logoutMessage.length()];
        int resultSize = deflater.deflate(buffer);
        byte[] output = new byte[resultSize];
        System.arraycopy(buffer, 0, output, 0, resultSize);
        return Base64.encodeBase64String((byte[])output);
    }

    public void setDisableSingleSignOut(boolean disableSingleSignOut) {
        this.disableSingleSignOut = disableSingleSignOut;
    }
}

