/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.PrincipalResolver;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.services.persondir.IPersonAttributeDao;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.StubPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonDirectoryPrincipalResolver
implements PrincipalResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean returnNullIfNoAttributes = false;
    @NotNull
    private IPersonAttributeDao attributeRepository = new StubPersonAttributeDao(new HashMap());
    private String principalAttributeName;

    @Override
    public boolean supports(Credential credential) {
        return true;
    }

    @Override
    public final Principal resolve(Credential credential) {
        this.logger.debug("Attempting to resolve a principal...");
        String principalId = this.extractPrincipalId(credential);
        if (principalId == null) {
            this.logger.debug("Got null for extracted principal ID; returning null.");
            return null;
        }
        this.logger.debug("Creating SimplePrincipal for [{}]", (Object)principalId);
        IPersonAttributes personAttributes = this.attributeRepository.getPerson(principalId);
        Map attributes = personAttributes == null ? null : personAttributes.getAttributes();
        if (attributes == null & !this.returnNullIfNoAttributes) {
            return new SimplePrincipal(principalId);
        }
        if (attributes == null) {
            return null;
        }
        HashMap<String, Object> convertedAttributes = new HashMap<String, Object>();
        for (String key : attributes.keySet()) {
            List values = (List)attributes.get(key);
            if (key.equalsIgnoreCase(this.principalAttributeName)) {
                if (values.isEmpty()) {
                    this.logger.debug("{} is empty, using {} for principal", (Object)this.principalAttributeName, (Object)principalId);
                    continue;
                }
                principalId = values.get(0).toString();
                this.logger.debug("Found principal attribute value {}; removing {} from attribute map.", (Object)principalId, (Object)this.principalAttributeName);
                continue;
            }
            convertedAttributes.put(key, values.size() == 1 ? values.get(0) : values);
        }
        return new SimplePrincipal(principalId, convertedAttributes);
    }

    public final void setAttributeRepository(IPersonAttributeDao attributeRepository) {
        this.attributeRepository = attributeRepository;
    }

    public void setReturnNullIfNoAttributes(boolean returnNullIfNoAttributes) {
        this.returnNullIfNoAttributes = returnNullIfNoAttributes;
    }

    public void setPrincipalAttributeName(String attribute) {
        this.principalAttributeName = attribute;
    }

    protected String extractPrincipalId(Credential credential) {
        return credential.getId();
    }
}

