/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.ImmutableAuthentication;
import org.jasig.cas.authentication.principal.Principal;
import org.springframework.util.Assert;

public class AuthenticationBuilder {
    private Principal principal;
    private List<CredentialMetaData> credentials = new ArrayList<CredentialMetaData>();
    private Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private Map<String, HandlerResult> successes = new LinkedHashMap<String, HandlerResult>();
    private Map<String, Class<? extends Exception>> failures = new LinkedHashMap<String, Class<? extends Exception>>();
    private Date authenticationDate = new Date();

    public AuthenticationBuilder() {
    }

    public AuthenticationBuilder(Principal p) {
        this();
        this.principal = p;
    }

    public Date getAuthenticationDate() {
        return this.authenticationDate;
    }

    public AuthenticationBuilder setAuthenticationDate(Date d) {
        this.authenticationDate = d;
        return this;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public AuthenticationBuilder setPrincipal(Principal p) {
        this.principal = p;
        return this;
    }

    public List<CredentialMetaData> getCredentials() {
        return this.credentials;
    }

    public AuthenticationBuilder setCredentials(List<CredentialMetaData> credentials) {
        Assert.notNull(credentials, (String)"Credential cannot be null");
        this.credentials.clear();
        for (CredentialMetaData c : credentials) {
            this.credentials.add(c);
        }
        return this;
    }

    public AuthenticationBuilder addCredential(CredentialMetaData credential) {
        this.credentials.add(credential);
        return this;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public AuthenticationBuilder setAttributes(Map<String, Object> attributes) {
        Assert.notNull(attributes, (String)"Attributes cannot be null");
        this.attributes.clear();
        for (String name : attributes.keySet()) {
            this.attributes.put(name, attributes.get(name));
        }
        return this;
    }

    public AuthenticationBuilder addAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public Map<String, HandlerResult> getSuccesses() {
        return this.successes;
    }

    public AuthenticationBuilder setSuccesses(Map<String, HandlerResult> successes) {
        Assert.notNull(successes, (String)"Successes cannot be null");
        this.successes.clear();
        for (String handler : successes.keySet()) {
            this.successes.put(handler, successes.get(handler));
        }
        return this;
    }

    public AuthenticationBuilder addSuccess(String key, HandlerResult value) {
        this.successes.put(key, value);
        return this;
    }

    public Map<String, Class<? extends Exception>> getFailures() {
        return this.failures;
    }

    public AuthenticationBuilder setFailures(Map<String, Class<? extends Exception>> failures) {
        Assert.notNull(failures, (String)"Failures cannot be null");
        this.failures.clear();
        for (String handler : failures.keySet()) {
            this.failures.put(handler, failures.get(handler));
        }
        return this;
    }

    public AuthenticationBuilder addFailure(String key, Class<? extends Exception> value) {
        this.failures.put(key, value);
        return this;
    }

    public Authentication build() {
        return new ImmutableAuthentication(this.authenticationDate, this.credentials, this.principal, this.attributes, this.successes, this.failures);
    }

    public static AuthenticationBuilder newInstance(Authentication source) {
        AuthenticationBuilder builder = new AuthenticationBuilder(source.getPrincipal());
        builder.setAuthenticationDate(source.getAuthenticatedDate());
        builder.setCredentials(source.getCredentials());
        builder.setSuccesses(source.getSuccesses());
        builder.setFailures(source.getFailures());
        builder.setAttributes(source.getAttributes());
        return builder;
    }
}

