/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.selfservice.example;

import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import org.forgerock.json.jose.jws.SigningManager;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.selfservice.core.snapshot.SnapshotTokenConfig;
import org.forgerock.selfservice.core.snapshot.SnapshotTokenHandler;
import org.forgerock.selfservice.core.snapshot.SnapshotTokenHandlerFactory;
import org.forgerock.selfservice.stages.tokenhandlers.JwtTokenHandler;
import org.forgerock.selfservice.stages.tokenhandlers.JwtTokenHandlerConfig;

final class ExampleTokenHandlerFactory
implements SnapshotTokenHandlerFactory {
    ExampleTokenHandlerFactory() {
    }

    public SnapshotTokenHandler get(SnapshotTokenConfig snapshotTokenConfig) {
        switch (snapshotTokenConfig.getType()) {
            case "jwt": {
                return this.createJwtTokenHandler((JwtTokenHandlerConfig)snapshotTokenConfig);
            }
        }
        throw new IllegalArgumentException("Unknown type " + snapshotTokenConfig.getType());
    }

    private SnapshotTokenHandler createJwtTokenHandler(JwtTokenHandlerConfig config) {
        try {
            SigningManager signingManager = new SigningManager();
            SigningHandler signingHandler = signingManager.newHmacSigningHandler(config.getSharedKey());
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(config.getKeyPairAlgorithm());
            keyPairGen.initialize(config.getKeyPairSize());
            return new JwtTokenHandler(config.getJweAlgorithm(), config.getEncryptionMethod(), keyPairGen.generateKeyPair(), config.getJwsAlgorithm(), signingHandler, config.getTokenLifeTimeInSeconds());
        }
        catch (NoSuchAlgorithmException nsaE) {
            throw new RuntimeException("Unable to create key pair for encryption", nsaE);
        }
    }
}

