/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.selfservice.example;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.forgerock.http.Client;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplication;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.handler.HttpClientHandler;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.routing.RouteMatchers;
import org.forgerock.http.routing.Router;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.MemoryBackend;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourcePath;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.SingletonResourceProvider;
import org.forgerock.json.resource.http.CrestHttp;
import org.forgerock.selfservice.core.AnonymousProcessService;
import org.forgerock.selfservice.core.ProcessStore;
import org.forgerock.selfservice.core.ProgressStageProvider;
import org.forgerock.selfservice.core.UserUpdateService;
import org.forgerock.selfservice.core.snapshot.SnapshotTokenHandlerFactory;
import org.forgerock.selfservice.example.ExampleEmailService;
import org.forgerock.selfservice.example.ExampleProgressStageProvider;
import org.forgerock.selfservice.example.ExampleTokenHandlerFactory;
import org.forgerock.selfservice.example.JsonReader;
import org.forgerock.selfservice.example.SimpleInMemoryStore;
import org.forgerock.selfservice.json.JsonAnonymousProcessServiceBuilder;
import org.forgerock.util.Factory;

public final class ExampleSelfServiceApplication
implements HttpApplication {
    private ConnectionFactory crestConnectionFactory;
    private org.forgerock.json.resource.Router crestRouter;
    private JsonValue appConfig;
    private Client httpClient;

    public Handler start() throws HttpApplicationException {
        try {
            this.appConfig = JsonReader.jsonFileToJsonValue("/config.json");
            this.httpClient = new Client((Handler)new HttpClientHandler());
            this.crestRouter = new org.forgerock.json.resource.Router();
            this.crestConnectionFactory = Resources.newInternalConnectionFactory((RequestHandler)this.crestRouter);
            this.registerCRESTServices();
            Router chfRouter = new Router();
            chfRouter.addRoute(RouteMatchers.requestUriMatcher((RoutingMode)RoutingMode.STARTS_WITH, (String)"internal"), (Object)CrestHttp.newHttpHandler((ConnectionFactory)this.crestConnectionFactory));
            chfRouter.addRoute(RouteMatchers.requestUriMatcher((RoutingMode)RoutingMode.STARTS_WITH, (String)"reset"), (Object)this.registerResetHandler());
            chfRouter.addRoute(RouteMatchers.requestUriMatcher((RoutingMode)RoutingMode.STARTS_WITH, (String)"username"), (Object)this.registerUsernameHandler());
            chfRouter.addRoute(RouteMatchers.requestUriMatcher((RoutingMode)RoutingMode.STARTS_WITH, (String)"registration"), (Object)this.registerRegistrationHandler());
            chfRouter.addRoute(RouteMatchers.requestUriMatcher((RoutingMode)RoutingMode.STARTS_WITH, (String)"user"), (Object)this.registerUserKBAUpdateHandler());
            return chfRouter;
        }
        catch (Exception e) {
            throw new HttpApplicationException("Some error starting", (Throwable)e);
        }
    }

    private void registerCRESTServices() throws ResourceException {
        this.crestRouter.addRoute(org.forgerock.json.resource.Router.uriTemplate((String)"users"), (CollectionResourceProvider)new MemoryBackend());
        this.crestRouter.addRoute(org.forgerock.json.resource.Router.uriTemplate((String)"email"), (SingletonResourceProvider)new ExampleEmailService(this.appConfig.get("mailserver")));
    }

    private Handler buildHandler(String configResource) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonValue json = new JsonValue(mapper.readValue(this.getClass().getResource(configResource), Map.class));
        AnonymousProcessService service = JsonAnonymousProcessServiceBuilder.newBuilder().withJsonConfig(json).withProgressStageProvider((ProgressStageProvider)new ExampleProgressStageProvider(this.crestConnectionFactory, this.httpClient)).withTokenHandlerFactory((SnapshotTokenHandlerFactory)new ExampleTokenHandlerFactory()).withProcessStore((ProcessStore)new SimpleInMemoryStore()).build();
        return CrestHttp.newHttpHandler((ConnectionFactory)Resources.newInternalConnectionFactory((RequestHandler)service));
    }

    private Handler registerResetHandler() throws Exception {
        return this.buildHandler("/reset.json");
    }

    private Handler registerUsernameHandler() throws Exception {
        return this.buildHandler("/username.json");
    }

    private Handler registerRegistrationHandler() throws Exception {
        return this.buildHandler("/registration.json");
    }

    private Handler registerUserKBAUpdateHandler() {
        return CrestHttp.newHttpHandler((ConnectionFactory)Resources.newInternalConnectionFactory((RequestHandler)Resources.newCollection((Object)new UserUpdateService(this.crestConnectionFactory, ResourcePath.resourcePath((String)"users"), new JsonPointer("kbaInfo")))));
    }

    public Factory<Buffer> getBufferFactory() {
        return null;
    }

    public void stop() {
    }
}

