/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.selfservice.example;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.forgerock.http.Client;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.selfservice.core.ProgressStage;
import org.forgerock.selfservice.core.ProgressStageProvider;
import org.forgerock.selfservice.core.config.StageConfig;
import org.forgerock.selfservice.core.config.StageConfigException;

final class ExampleProgressStageProvider
implements ProgressStageProvider {
    private final ConnectionFactory connectionFactory;
    private final Client client;

    ExampleProgressStageProvider(ConnectionFactory connectionFactory, Client client) {
        this.connectionFactory = connectionFactory;
        this.client = client;
    }

    public ProgressStage<StageConfig> get(Class<? extends ProgressStage<StageConfig>> progressStageClass) {
        Constructor<?>[] constructors = progressStageClass.getConstructors();
        if (constructors.length > 1) {
            throw new StageConfigException("Only expected one constructor for the configured progress stage " + progressStageClass);
        }
        try {
            Constructor<? extends ProgressStage<StageConfig>> constructor = progressStageClass.getConstructor(constructors[0].getParameterTypes());
            Object[] parameters = this.getParameters(constructor);
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new StageConfigException("Unable to instantiate the configured progress stage", (Throwable)e);
        }
    }

    private Object[] getParameters(Constructor<?> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].equals(ConnectionFactory.class)) {
                parameters[i] = this.connectionFactory;
                continue;
            }
            if (parameterTypes[i].equals(Client.class)) {
                parameters[i] = this.client;
                continue;
            }
            throw new StageConfigException("Unexpected parameter type for configured progress stage " + parameters[i]);
        }
        return parameters;
    }
}

